/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.annotation;

import jakarta.annotation.Nonnull;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.annotation.DeadlineHandlingMember;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DeadlineMethodMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.attribute("DeadlineHandler.deadlineName").map(deadlineName -> new DeadlineMethodMessageHandlingMember(original, (String)deadlineName)).orElse(original);
    }

    private static class DeadlineMethodMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements DeadlineHandlingMember<T> {
        private final String deadlineName;

        private DeadlineMethodMessageHandlingMember(MessageHandlingMember<T> delegate, String deadlineName) {
            super(delegate);
            this.deadlineName = deadlineName;
        }

        @Override
        public boolean canHandle(@Nonnull Message message, @Nonnull ProcessingContext context) {
            DeadlineMessage dm;
            return message instanceof DeadlineMessage && this.deadlineNameMatch(dm = (DeadlineMessage)message) && super.canHandle(message, context);
        }

        private boolean deadlineNameMatch(DeadlineMessage message) {
            return this.deadlineNameMatchesAll() || this.deadlineName.equals(message.getDeadlineName());
        }

        private boolean deadlineNameMatchesAll() {
            return this.deadlineName.isEmpty();
        }

        @Override
        public int priority() {
            if (!this.deadlineNameMatchesAll()) {
                return 10000 + Math.min(2147473647, super.priority());
            }
            return 1000 + Math.min(2147482647, super.priority());
        }
    }
}

