/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.common.ObjectUtils;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Converter;

public class GenericDeadlineMessage
extends GenericEventMessage
implements DeadlineMessage {
    private final String deadlineName;

    public GenericDeadlineMessage(@Nonnull MessageType type, @Nonnull String deadlineName) {
        this(deadlineName, type, null);
    }

    public GenericDeadlineMessage(@Nonnull String deadlineName, @Nonnull MessageType type, @Nullable Object payload) {
        this(deadlineName, type, payload, MetaData.emptyInstance());
    }

    public GenericDeadlineMessage(@Nonnull String deadlineName, @Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metaData) {
        super(type, payload, metaData);
        this.deadlineName = deadlineName;
    }

    public GenericDeadlineMessage(@Nonnull String deadlineName, @Nonnull String identifier, @Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metaData, @Nonnull Instant timestamp) {
        super(identifier, type, payload, metaData, timestamp);
        this.deadlineName = deadlineName;
    }

    public GenericDeadlineMessage(@Nonnull String deadlineName, @Nonnull Message delegate, @Nonnull Supplier<Instant> timestampSupplier) {
        super(delegate, timestampSupplier);
        this.deadlineName = deadlineName;
    }

    @Override
    @Nonnull
    public String getDeadlineName() {
        return this.deadlineName;
    }

    @Override
    @Nonnull
    public DeadlineMessage withMetaData(@Nonnull Map<String, String> metaData) {
        return new GenericDeadlineMessage(this.deadlineName, this.delegate().withMetaData(metaData), this::timestamp);
    }

    @Override
    @Nonnull
    public DeadlineMessage andMetaData(@Nonnull Map<String, String> additionalMetaData) {
        return new GenericDeadlineMessage(this.deadlineName, this.delegate().andMetaData(additionalMetaData), this::timestamp);
    }

    @Override
    @Nonnull
    public DeadlineMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, delegate.metaData());
        return new GenericDeadlineMessage(this.getDeadlineName(), converted, this::timestamp);
    }

    @Override
    protected String describeType() {
        return "GenericDeadlineMessage";
    }
}

