/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.DefaultMessageDispatchInterceptorChain;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;

public abstract class AbstractDeadlineManager
implements DeadlineManager {
    private final List<MessageDispatchInterceptor<? super DeadlineMessage>> dispatchInterceptors = new CopyOnWriteArrayList<MessageDispatchInterceptor<? super DeadlineMessage>>();
    private final List<MessageHandlerInterceptor<? super DeadlineMessage>> handlerInterceptors = new CopyOnWriteArrayList<MessageHandlerInterceptor<? super DeadlineMessage>>();
    protected MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

    protected void runOnPrepareCommitOrNow(Runnable deadlineCall) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().onPrepareCommit(unitOfWork -> deadlineCall.run());
        } else {
            deadlineCall.run();
        }
    }

    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super DeadlineMessage> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<DeadlineMessage> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    protected List<MessageDispatchInterceptor<? super DeadlineMessage>> dispatchInterceptors() {
        return Collections.unmodifiableList(this.dispatchInterceptors);
    }

    protected List<MessageHandlerInterceptor<? super DeadlineMessage>> handlerInterceptors() {
        return Collections.unmodifiableList(this.handlerInterceptors);
    }

    protected DeadlineMessage processDispatchInterceptors(DeadlineMessage message) {
        try {
            return (DeadlineMessage)new DefaultMessageDispatchInterceptorChain<DeadlineMessage>(this.dispatchInterceptors()).proceed(message, null).first().cast().asCompletableFuture().get().message();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected DeadlineMessage asDeadlineMessage(@Nonnull String deadlineName, Object messageOrPayload, @Nonnull Instant expiryTime) {
        if (messageOrPayload instanceof Message) {
            return new GenericDeadlineMessage(deadlineName, (Message)messageOrPayload, () -> expiryTime);
        }
        MessageType type = this.messageTypeResolver.resolveOrThrow(ObjectUtils.nullSafeTypeOf(messageOrPayload));
        return new GenericDeadlineMessage(deadlineName, new GenericMessage(type, messageOrPayload), () -> expiryTime);
    }
}

