/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.common.FutureUtils;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LifecycleHandler;

public interface LifecycleRegistry {
    public LifecycleRegistry registerLifecyclePhaseTimeout(long var1, @Nonnull TimeUnit var3);

    default public LifecycleRegistry onStart(@Nonnull Runnable startHandler) {
        return this.onStart(0, startHandler);
    }

    default public LifecycleRegistry onStart(int phase, @Nonnull Runnable startHandler) {
        Objects.requireNonNull(startHandler, "The start handler must not be null.");
        return this.onStart(phase, (Configuration configuration) -> startHandler.run());
    }

    default public LifecycleRegistry onStart(int phase, @Nonnull Supplier<CompletableFuture<?>> startHandler) {
        Objects.requireNonNull(startHandler, "The start handler must not be null.");
        return this.onStart(phase, (Configuration configuration) -> (CompletableFuture)startHandler.get());
    }

    default public LifecycleRegistry onStart(int phase, @Nonnull Consumer<Configuration> startHandler) {
        Objects.requireNonNull(startHandler, "startHandler must not be null");
        return this.onStart(phase, (Configuration configuration) -> {
            try {
                startHandler.accept(configuration);
                return FutureUtils.emptyCompletedFuture();
            }
            catch (Exception e) {
                CompletableFuture exceptionResult = new CompletableFuture();
                exceptionResult.completeExceptionally(e);
                return exceptionResult;
            }
        });
    }

    public LifecycleRegistry onStart(int var1, @Nonnull LifecycleHandler var2);

    default public LifecycleRegistry onShutdown(@Nonnull Runnable shutdownHandler) {
        return this.onShutdown(0, shutdownHandler);
    }

    default public LifecycleRegistry onShutdown(int phase, @Nonnull Runnable shutdownHandler) {
        Objects.requireNonNull(shutdownHandler, "The shutdown handler must not be null.");
        return this.onShutdown(phase, (Configuration configuration) -> shutdownHandler.run());
    }

    default public LifecycleRegistry onShutdown(int phase, @Nonnull Supplier<CompletableFuture<?>> shutdownHandler) {
        Objects.requireNonNull(shutdownHandler, "The shutdown handler must not be null.");
        return this.onShutdown(phase, (Configuration configuration) -> (CompletableFuture)shutdownHandler.get());
    }

    default public LifecycleRegistry onShutdown(int phase, @Nonnull Consumer<Configuration> shutdownHandler) {
        Objects.requireNonNull(shutdownHandler, "shutdownHandler must not be null");
        return this.onShutdown(phase, (Configuration configuration) -> {
            try {
                shutdownHandler.accept(configuration);
                return FutureUtils.emptyCompletedFuture();
            }
            catch (Exception e) {
                CompletableFuture exceptionResult = new CompletableFuture();
                exceptionResult.completeExceptionally(e);
                return exceptionResult;
            }
        });
    }

    public LifecycleRegistry onShutdown(int var1, @Nonnull LifecycleHandler var2);
}

