/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.stream;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.axonframework.common.stream.StreamUtils;

public interface BlockingStream<M>
extends AutoCloseable {
    default public boolean hasNextAvailable() {
        try {
            return this.hasNextAvailable(0, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public Optional<M> peek();

    public boolean hasNextAvailable(int var1, TimeUnit var2) throws InterruptedException;

    public M nextAvailable() throws InterruptedException;

    @Override
    public void close();

    default public Stream<M> asStream() {
        return StreamUtils.asStream(this);
    }

    default public void skipMessagesWithPayloadTypeOf(M ignoredMessage) {
    }

    default public boolean setOnAvailableCallback(Runnable callback) {
        return false;
    }
}

