/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandPriorityCalculator;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.commandhandling.gateway.FutureCommandResult;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DefaultCommandGateway
implements CommandGateway {
    private final CommandBus commandBus;
    private final MessageTypeResolver messageTypeResolver;
    private final CommandPriorityCalculator priorityCalculator;
    private final RoutingStrategy routingKeyResolver;

    public DefaultCommandGateway(@Nonnull CommandBus commandBus, @Nonnull MessageTypeResolver messageTypeResolver) {
        this(commandBus, messageTypeResolver, null, null);
    }

    public DefaultCommandGateway(@Nonnull CommandBus commandBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nullable CommandPriorityCalculator priorityCalculator, @Nullable RoutingStrategy routingKeyResolver) {
        this.commandBus = Objects.requireNonNull(commandBus, "The commandBus may not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The messageTypeResolver may not be null.");
        this.priorityCalculator = priorityCalculator;
        this.routingKeyResolver = routingKeyResolver;
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nullable ProcessingContext context) {
        CommandMessage commandMessage = this.asCommandMessage(command, MetaData.emptyInstance());
        return new FutureCommandResult((CompletableFuture<? extends Message>)this.commandBus.dispatch(commandMessage, context).thenCompose(msg -> {
            CommandResultMessage resultMessage;
            return msg instanceof ResultMessage && (resultMessage = msg).isExceptional() ? CompletableFuture.failedFuture(resultMessage.exceptionResult()) : CompletableFuture.completedFuture(msg);
        }));
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nonnull MetaData metaData, @Nullable ProcessingContext context) {
        CommandMessage commandMessage = this.asCommandMessage(command, metaData);
        return new FutureCommandResult((CompletableFuture<? extends Message>)this.commandBus.dispatch(commandMessage, context).thenCompose(msg -> {
            CommandResultMessage resultMessage;
            return msg instanceof ResultMessage && (resultMessage = msg).isExceptional() ? CompletableFuture.failedFuture(resultMessage.exceptionResult()) : CompletableFuture.completedFuture(msg);
        }));
    }

    private CommandMessage asCommandMessage(Object command, MetaData metaData) {
        CommandMessage commandMessage = this.createCommandMessage(command, metaData);
        return this.enrichCommandMessage(commandMessage);
    }

    private CommandMessage createCommandMessage(Object command, MetaData metaData) {
        GenericCommandMessage genericCommandMessage;
        if (command instanceof CommandMessage) {
            return (CommandMessage)command;
        }
        if (command instanceof Message) {
            Message message = (Message)command;
            genericCommandMessage = new GenericCommandMessage(message.type(), message.payload(), message.metaData());
        } else {
            genericCommandMessage = new GenericCommandMessage(this.messageTypeResolver.resolveOrThrow(command), command, metaData);
        }
        return genericCommandMessage;
    }

    private CommandMessage enrichCommandMessage(CommandMessage commandMessage) {
        if (this.routingKeyResolver == null && this.priorityCalculator == null) {
            return commandMessage;
        }
        return new GenericCommandMessage(commandMessage, commandMessage.routingKey().orElse(this.resolveRoutingKey(commandMessage)), commandMessage.priority().orElse(this.resolvePriority(commandMessage).orElse(0)));
    }

    private String resolveRoutingKey(CommandMessage commandMessage) {
        return this.routingKeyResolver == null ? null : this.routingKeyResolver.getRoutingKey(commandMessage);
    }

    private OptionalInt resolvePriority(CommandMessage commandMessage) {
        return this.priorityCalculator == null ? OptionalInt.empty() : OptionalInt.of(this.priorityCalculator.determinePriority(commandMessage));
    }
}

