/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.ConversionException;

public interface CommandResult {
    public CompletableFuture<? extends Message> getResultMessage();

    default public <R> CompletableFuture<R> resultAs(@Nonnull Class<R> type) {
        Objects.requireNonNull(type, "The result type must not be null");
        return this.getResultMessage().thenApply(r -> {
            if (r == null || r.payload() == null) {
                return null;
            }
            if (type.isInstance(r.payload())) {
                return type.cast(r.payload());
            }
            throw new ConversionException(String.format("Expected result of type [%s] in the CommandResult, but got [%s]", type.getName(), r.payloadType().getName()));
        });
    }

    default public CommandResult onSuccess(@Nonnull Consumer<Message> successHandler) {
        Objects.requireNonNull(successHandler, "The success handler must not be null.");
        this.getResultMessage().whenComplete((r, e) -> {
            if (e == null) {
                successHandler.accept((Message)r);
            }
        });
        return this;
    }

    default public <R> CommandResult onSuccess(@Nonnull Class<R> resultType, @Nonnull BiConsumer<R, Message> successHandler) {
        Objects.requireNonNull(resultType, "The result type must not be null.");
        Objects.requireNonNull(successHandler, "The success handler must not be null.");
        this.getResultMessage().whenComplete((r, e) -> {
            if (e == null) {
                successHandler.accept((Object)resultType.cast(r.payload()), (Message)r);
            }
        });
        return this;
    }

    default public <R> CommandResult onSuccess(@Nonnull Class<R> resultType, @Nonnull Consumer<R> successHandler) {
        Objects.requireNonNull(successHandler, "The success handler must not be null.");
        return this.onSuccess(resultType, (R result, Message message) -> successHandler.accept(result));
    }

    default public CommandResult onError(@Nonnull Consumer<Throwable> errorHandler) {
        Objects.requireNonNull(errorHandler, "The error handler must not be null.");
        this.getResultMessage().whenComplete((r, e) -> {
            if (e != null) {
                errorHandler.accept((Throwable)e);
            }
        });
        return this;
    }
}

