/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface CommandGateway {
    default public <R> CompletableFuture<R> send(@Nonnull Object command, @Nullable ProcessingContext context, @Nonnull Class<R> expectedType) {
        return this.send(command, context).resultAs(expectedType);
    }

    default public void sendAndWait(@Nonnull Object command) {
        try {
            this.send(command, null).getResultMessage().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandExecutionException("Thread interrupted while waiting for result", e);
        }
        catch (ExecutionException e) {
            throw new CommandExecutionException("Exception while handling command", e);
        }
    }

    default public <R> R sendAndWait(@Nonnull Object command, @Nonnull Class<R> resultType) {
        try {
            return this.send(command, null).resultAs(resultType).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandExecutionException("Thread interrupted while waiting for result", e);
        }
        catch (ExecutionException e) {
            throw new CommandExecutionException("Exception while handling command", e);
        }
    }

    public CommandResult send(@Nonnull Object var1, @Nullable ProcessingContext var2);

    public CommandResult send(@Nonnull Object var1, @Nonnull MetaData var2, @Nullable ProcessingContext var3);
}

