/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.annotation.AnnotatedCommandHandlingComponent;
import org.axonframework.commandhandling.configuration.SimpleCommandHandlingModule;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.conversion.MessageConverter;

public interface CommandHandlingModule
extends Module,
ModuleBuilder<CommandHandlingModule> {
    public static SetupPhase named(@Nonnull String moduleName) {
        return new SimpleCommandHandlingModule(moduleName);
    }

    public static interface CommandHandlerPhase
    extends SetupPhase,
    ModuleBuilder<CommandHandlingModule> {
        default public CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull CommandHandler commandHandler) {
            Objects.requireNonNull(commandHandler, "The command handler cannot be null.");
            return this.commandHandler(commandName, (Configuration cfg) -> commandHandler);
        }

        public CommandHandlerPhase commandHandler(@Nonnull QualifiedName var1, @Nonnull ComponentBuilder<CommandHandler> var2);

        public CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentBuilder<CommandHandlingComponent> var1);

        default public CommandHandlerPhase annotatedCommandHandlingComponent(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.commandHandlingComponent(c -> new AnnotatedCommandHandlingComponent(handlingComponentBuilder.build(c), c.getComponent(ParameterResolverFactory.class), c.getComponent(MessageConverter.class)));
        }
    }

    public static interface SetupPhase {
        public CommandHandlerPhase commandHandlers();

        default public CommandHandlerPhase commandHandlers(@Nonnull Consumer<CommandHandlerPhase> configurationLambda) {
            CommandHandlerPhase commandHandlerPhase = this.commandHandlers();
            Objects.requireNonNull(configurationLambda, "The command handler configuration lambda cannot be null.").accept(commandHandlerPhase);
            return commandHandlerPhase;
        }
    }
}

