/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import jakarta.annotation.Nonnull;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.common.annotation.Internal;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class UpdateCheckerHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerHttpClient.class);
    private final HttpClient client;
    private final UsagePropertyProvider userProperties;

    public UpdateCheckerHttpClient(@Nonnull UsagePropertyProvider userProperties) {
        this.userProperties = Objects.requireNonNull(userProperties, "The userProperties must not be null.");
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    }

    public Optional<UpdateCheckResponse> sendRequest(@Nonnull UpdateCheckRequest updateCheckRequest, boolean firstRequest) {
        String url = this.userProperties.getUrl() + "?" + updateCheckRequest.toQueryString();
        try {
            logger.debug("Reporting anonymous usage data to AxonIQ servers at: {}", (Object)url);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).headers("User-Agent", updateCheckRequest.toUserAgent()).headers("X-Machine-Id", updateCheckRequest.machineId()).headers("X-Instance-Id", updateCheckRequest.instanceId()).headers("X-Uptime", String.valueOf(ManagementFactory.getRuntimeMXBean().getUptime())).headers("X-First-Run", firstRequest ? "true" : "false").GET().build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                logger.info("Failed to report anonymous usage data, received status code: {}", (Object)response.statusCode());
                return Optional.empty();
            }
            logger.debug("Reported anonymous usage data successfully, received response: {}", (Object)response.body());
            return Optional.of(UpdateCheckResponse.fromRequest(response.body()));
        }
        catch (Exception e) {
            logger.warn("Failed to report anonymous usage data", (Throwable)e);
            return Optional.empty();
        }
    }
}

