/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.serialization.Converter;

public final class PassThroughConverter
implements Converter {
    @Override
    public boolean canConvert(@Nonnull Class<?> sourceType, @Nonnull Class<?> targetType) {
        return sourceType.equals(targetType);
    }

    @Override
    @Nullable
    public <S, T> T convert(@Nullable S input, @Nonnull Class<S> sourceType, @Nonnull Class<T> targetType) {
        if (input == null) {
            return null;
        }
        if (sourceType.equals(targetType)) {
            return targetType.cast(input);
        }
        throw new IllegalArgumentException("PassThroughConverter only supports conversion when source and target types are the same. Source: " + sourceType.getName() + ", Target: " + targetType.getName());
    }
}

