/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SimpleSerializedObject;

public interface Converter {
    public boolean canConvert(@Nonnull Class<?> var1, @Nonnull Class<?> var2);

    @Nullable
    default public <S, T> T convert(@Nullable S input, @Nonnull Class<T> targetType) {
        return input != null ? (T)this.convert(input, input.getClass(), targetType) : null;
    }

    @Nullable
    public <S, T> T convert(@Nullable S var1, @Nonnull Class<S> var2, @Nonnull Class<T> var3);

    @Deprecated(forRemoval=true, since="5.0.0")
    default public <T, S> SerializedObject<T> convert(SerializedObject<S> original, Class<T> targetType) {
        if (original.getContentType().equals(targetType)) {
            return original;
        }
        return new SimpleSerializedObject<T>(this.convert(original.getData(), original.getContentType(), targetType), targetType, original.getType());
    }
}

