/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.serialization.ChainedConverter;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(ChainingConverter.class);
    private final List<ContentTypeConverter<?, ?>> converters = new CopyOnWriteArrayList();

    public ChainingConverter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ChainingConverter(ClassLoader classLoader) {
        ServiceLoader<ContentTypeConverter> converterLoader = ServiceLoader.load(ContentTypeConverter.class, classLoader);
        for (ContentTypeConverter converter : converterLoader) {
            this.converters.add(converter);
        }
    }

    @Override
    public boolean canConvert(@Nonnull Class<?> sourceType, @Nonnull Class<?> targetType) {
        if (sourceType.equals(targetType)) {
            return true;
        }
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, sourceType, targetType)) continue;
            return true;
        }
        return ChainedConverter.canConvert(sourceType, targetType, this.converters);
    }

    @Override
    @Nullable
    public <S, T> T convert(@Nullable S input, @Nonnull Class<S> sourceType, @Nonnull Class<T> targetType) {
        if (sourceType.equals(targetType) || input == null) {
            return (T)input;
        }
        for (ContentTypeConverter<?, ?> converter : this.converters) {
            if (!this.canConvert(converter, sourceType, targetType)) continue;
            ContentTypeConverter<?, ?> typedConverter = converter;
            return (T)typedConverter.convert(input);
        }
        ChainedConverter<S, T> converter = ChainedConverter.calculateChain(sourceType, targetType, this.converters);
        this.converters.addFirst(converter);
        return converter.convert(input);
    }

    private <S, T> boolean canConvert(ContentTypeConverter<?, ?> converter, Class<S> sourceContentType, Class<T> targetContentType) {
        try {
            if (converter.expectedSourceType().isAssignableFrom(sourceContentType) && targetContentType.isAssignableFrom(converter.targetType())) {
                return true;
            }
            converter.targetType();
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converter, (Object)e.getMessage());
            this.converters.remove(converter);
        }
        return false;
    }

    public void registerConverter(@Nonnull ContentTypeConverter<?, ?> converter) {
        this.converters.addFirst(converter);
    }

    public void registerConverter(@Nonnull Class<? extends ContentTypeConverter<?, ?>> converterType) {
        try {
            ContentTypeConverter<?, ?> converter = converterType.getConstructor(new Class[0]).newInstance(new Object[0]);
            converter.targetType();
            converter.expectedSourceType();
            this.registerConverter(converter);
        }
        catch (Exception e) {
            logger.warn("An exception occurred while trying to initialize a [{}].", (Object)converterType.getName(), (Object)e);
        }
        catch (NoClassDefFoundError e) {
            logger.info("ContentTypeConverter of type [{}] is ignored. It seems to rely on a class that is not available in the class loader: {}", converterType, (Object)e.getMessage());
        }
    }

    public void setAdditionalConverters(@Nonnull List<ContentTypeConverter<?, ?>> additionalConverters) {
        additionalConverters.forEach(this::registerConverter);
    }

    @Nonnull
    public List<ContentTypeConverter<?, ?>> getContentTypeConverters() {
        return Collections.unmodifiableList(this.converters);
    }
}

