/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class CorrelationDataInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T> {
    public static final Context.ResourceKey<Map<String, Object>> CORRELATION_DATA = Context.ResourceKey.withLabel("CorrelationData");
    private final List<CorrelationDataProvider> correlationDataProviders;

    public CorrelationDataInterceptor(CorrelationDataProvider ... correlationDataProviders) {
        this(Arrays.asList(correlationDataProviders));
    }

    public CorrelationDataInterceptor(Collection<CorrelationDataProvider> correlationDataProviders) {
        this.correlationDataProviders = new ArrayList<CorrelationDataProvider>(correlationDataProviders);
    }

    @Override
    public Object handle(@Nonnull LegacyUnitOfWork<? extends T> unitOfWork, @Nonnull ProcessingContext context, @Nonnull InterceptorChain interceptorChain) throws Exception {
        this.correlationDataProviders.forEach(unitOfWork::registerCorrelationDataProvider);
        return interceptorChain.proceedSync(context);
    }

    @Override
    public <M extends T, R extends Message<?>> MessageStream<R> interceptOnHandle(@Nonnull M message, ProcessingContext context, InterceptorChain<M, R> interceptorChain) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.correlationDataProviders.forEach(c -> map.putAll(c.correlationDataFor((Message<?>)message)));
        return interceptorChain.proceed(message, (ProcessingContext)context.withResource((Context.ResourceKey)CORRELATION_DATA, map));
    }
}

