/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import org.axonframework.common.Priority;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageIdentifier;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class MessageIdentifierParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<MessageIdentifier, String> {
    private final ParameterResolver<String> resolver = new MessageIdentifierParameterResolver();

    public MessageIdentifierParameterResolverFactory() {
        super(MessageIdentifier.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class MessageIdentifierParameterResolver
    implements ParameterResolver<String> {
        MessageIdentifierParameterResolver() {
        }

        @Override
        public String resolveParameterValue(@Nonnull ProcessingContext context) {
            return Message.fromContext(context).getIdentifier();
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) != null;
        }
    }
}

