/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotation.InterceptorChainParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.NoMoreInterceptors;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ChainedMessageHandlerInterceptorMember<T>
implements MessageHandlerInterceptorMemberChain<T> {
    private final MessageHandlingMember<? super T> delegate;
    private final MessageHandlerInterceptorMemberChain<T> next;

    public ChainedMessageHandlerInterceptorMember(Class<?> handlerType, Iterator<MessageHandlingMember<? super T>> iterator) {
        this.delegate = iterator.next();
        this.next = iterator.hasNext() ? new ChainedMessageHandlerInterceptorMember<T>(handlerType, iterator) : NoMoreInterceptors.instance();
    }

    @Override
    public MessageStream<?> handle(@Nonnull Message<?> message, @Nonnull ProcessingContext context, @Nonnull T target, @Nonnull MessageHandlingMember<? super T> handler) {
        return InterceptorChainParameterResolverFactory.callWithInterceptorChain(context, ctx -> this.next.handle(message, ctx, target, handler), ctx -> this.doHandle(message, (ProcessingContext)ctx, target, handler));
    }

    private MessageStream<?> doHandle(Message<?> message, ProcessingContext context, T target, MessageHandlingMember<? super T> handler) {
        return this.delegate.canHandle(message, context) ? this.delegate.handle(message, context, target) : this.next.handle(message, context, (T)target, handler);
    }

    @Override
    public Object handleSync(@Nonnull Message<?> message, @Nonnull ProcessingContext context, @Nonnull T target, @Nonnull MessageHandlingMember<? super T> handler) throws Exception {
        return InterceptorChainParameterResolverFactory.callWithInterceptorChainSync(ctx -> this.next.handleSync(message, ctx, target, handler), () -> this.doHandleSync(message, context, target, handler));
    }

    private Object doHandleSync(Message<?> message, ProcessingContext context, T target, MessageHandlingMember<? super T> handler) throws Exception {
        return this.delegate.canHandle(message, context) ? this.delegate.handleSync(message, context, target) : this.next.handleSync(message, context, (T)target, handler);
    }
}

