/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeNotResolvedException;

@FunctionalInterface
public interface MessageTypeResolver {
    default public MessageType resolveOrThrow(Object payload) {
        if (payload instanceof Message) {
            return ((Message)payload).type();
        }
        return this.resolveOrThrow(ObjectUtils.nullSafeTypeOf(payload));
    }

    default public MessageType resolveOrThrow(@Nonnull Class<?> payloadType) {
        return this.resolve(payloadType).orElseThrow(() -> new MessageTypeNotResolvedException("Cannot resolve MessageType for the payload type [" + payloadType.getName() + "]"));
    }

    default public Optional<MessageType> resolve(@Nonnull Object payload) {
        if (payload instanceof Message) {
            return Optional.of(((Message)payload).type());
        }
        return this.resolve(ObjectUtils.nullSafeTypeOf(payload));
    }

    public Optional<MessageType> resolve(@Nonnull Class<?> var1);
}

