/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.replay.ReplayContext;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayContextParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    @Nullable
    public ParameterResolver createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (parameter.isAnnotationPresent(ReplayContext.class)) {
            return new ReplayContextParameterResolver(parameter.getType());
        }
        return null;
    }

    private static class ReplayContextParameterResolver
    implements ParameterResolver<Object> {
        private final Class<?> type;

        public ReplayContextParameterResolver(Class<?> type) {
            this.type = type;
        }

        @Override
        @Nullable
        public Object resolveParameterValue(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            if (message instanceof TrackedEventMessage) {
                TrackedEventMessage trackedEventMessage = (TrackedEventMessage)message;
                return ReplayToken.replayContext(trackedEventMessage, this.type).orElse(null);
            }
            return false;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof TrackedEventMessage;
        }
    }
}

