/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

@Entity
@Table(indexes={@Index(columnList="processingGroup"), @Index(columnList="processingGroup,sequenceIdentifier"), @Index(columnList="processingGroup,sequenceIdentifier,sequenceIndex", unique=true)})
public class DeadLetterEntry {
    @Id
    private String deadLetterId;
    @Basic(optional=false)
    private String processingGroup;
    @Basic(optional=false)
    private String sequenceIdentifier;
    @Basic(optional=false)
    private long sequenceIndex;
    @Embedded
    private DeadLetterEventEntry message;
    @Basic(optional=false)
    private Instant enqueuedAt;
    private Instant lastTouched;
    private Instant processingStarted;
    private String causeType;
    @Column(length=1023)
    private String causeMessage;
    @Basic
    @Lob
    @Column(length=10000)
    private byte[] diagnostics;

    protected DeadLetterEntry() {
    }

    public DeadLetterEntry(String processingGroup, String sequenceIdentifier, long sequenceIndex, DeadLetterEventEntry message, Instant enqueuedAt, Instant lastTouched, Cause cause, MetaData diagnostics, Serializer serializer) {
        this.deadLetterId = IdentifierFactory.getInstance().generateIdentifier();
        this.processingGroup = processingGroup;
        this.sequenceIdentifier = sequenceIdentifier;
        this.sequenceIndex = sequenceIndex;
        this.message = message;
        this.enqueuedAt = enqueuedAt;
        this.lastTouched = lastTouched;
        if (cause != null) {
            this.causeType = cause.type();
            this.causeMessage = cause.message();
        }
        this.setDiagnostics(diagnostics, serializer);
    }

    public String getDeadLetterId() {
        return this.deadLetterId;
    }

    public String getProcessingGroup() {
        return this.processingGroup;
    }

    public String getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    public long getSequenceIndex() {
        return this.sequenceIndex;
    }

    public DeadLetterEventEntry getMessage() {
        return this.message;
    }

    public Instant getEnqueuedAt() {
        return this.enqueuedAt;
    }

    public Instant getLastTouched() {
        return this.lastTouched;
    }

    public void setLastTouched(Instant lastTouched) {
        this.lastTouched = lastTouched;
    }

    public Instant getProcessingStarted() {
        return this.processingStarted;
    }

    public String getCauseType() {
        return this.causeType;
    }

    public String getCauseMessage() {
        return this.causeMessage;
    }

    public SerializedObject<byte[]> getDiagnostics() {
        return new SimpleSerializedObject<byte[]>(this.diagnostics, byte[].class, MetaData.class.getName(), null);
    }

    public void setCause(Cause cause) {
        this.causeType = cause != null ? cause.type() : null;
        this.causeMessage = cause != null ? cause.message() : null;
    }

    public void setDiagnostics(MetaData diagnostics, Serializer serializer) {
        SerializedObject<byte[]> serializedDiagnostics = serializer.serialize(diagnostics, byte[].class);
        this.diagnostics = serializedDiagnostics.getData();
    }

    public void clearProcessingStarted() {
        this.processingStarted = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeadLetterEntry that = (DeadLetterEntry)o;
        return Objects.equals(this.deadLetterId, that.deadLetterId);
    }

    public int hashCode() {
        return this.deadLetterId != null ? this.deadLetterId.hashCode() : 0;
    }

    public String toString() {
        return "DeadLetterEntry{deadLetterId='" + this.deadLetterId + "', processingGroup='" + this.processingGroup + "', sequenceIdentifier='" + this.sequenceIdentifier + "', index=" + this.sequenceIndex + ", message=" + String.valueOf(this.message) + ", enqueuedAt=" + String.valueOf(this.enqueuedAt) + ", lastTouched=" + String.valueOf(this.lastTouched) + ", processingStarted=" + String.valueOf(this.processingStarted) + ", causeType='" + this.causeType + "', causeMessage='" + this.causeMessage + "', diagnostics=" + Arrays.toString(this.diagnostics) + "}";
    }
}

