/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleEventHandlingComponent
implements EventHandlingComponent {
    private final ConcurrentHashMap<QualifiedName, EventHandler> eventHandlers = new ConcurrentHashMap();

    @Override
    @Nonnull
    public MessageStream.Empty<Message<Void>> handle(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        QualifiedName name = event.type().qualifiedName();
        EventHandler handler = this.eventHandlers.get(name);
        if (handler == null) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for event with name [" + String.valueOf(name) + "]"));
        }
        return handler.handle(event, context);
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler handler) {
        names.forEach(name -> this.eventHandlers.put((QualifiedName)name, Objects.requireNonNull(handler, "TODO")));
        return this;
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler handler) {
        return this.subscribe((Set)Set.of(name), handler);
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.eventHandlers.keySet());
    }
}

