/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Optional;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ResetNotSupportedException;
import org.axonframework.eventhandling.replay.GenericResetContext;
import org.axonframework.eventhandling.replay.ResetContext;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.LegacyMessageSupportingContext;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class AnnotationEventHandlerAdapter
implements EventMessageHandler {
    private final AnnotatedHandlerInspector<Object> inspector;
    private final Class<?> listenerType;
    private final Object annotatedEventListener;
    private final MessageTypeResolver messageTypeResolver;

    public AnnotationEventHandlerAdapter(Object annotatedEventListener) {
        this(annotatedEventListener, ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass()), new ClassBasedMessageTypeResolver());
    }

    public AnnotationEventHandlerAdapter(Object annotatedEventListener, MessageTypeResolver messageTypeResolver) {
        this(annotatedEventListener, ClasspathParameterResolverFactory.forClass(annotatedEventListener.getClass()), messageTypeResolver);
    }

    public AnnotationEventHandlerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory, MessageTypeResolver messageTypeResolver) {
        this(annotatedEventListener, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedEventListener.getClass()), messageTypeResolver);
    }

    public AnnotationEventHandlerAdapter(Object annotatedEventListener, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, MessageTypeResolver messageTypeResolver) {
        BuilderUtils.assertNonNull(messageTypeResolver, "The Message Type Resolver may not be null");
        this.annotatedEventListener = annotatedEventListener;
        this.listenerType = annotatedEventListener.getClass();
        this.inspector = AnnotatedHandlerInspector.inspectType(annotatedEventListener.getClass(), parameterResolverFactory, handlerDefinition);
        this.messageTypeResolver = messageTypeResolver;
    }

    private static boolean supportsReplay(MessageHandlingMember<? super Object> h) {
        return h.attribute("AllowReplay.allowReplay").map(Boolean.TRUE::equals).orElse(Boolean.TRUE);
    }

    @Override
    public Object handleSync(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) throws Exception {
        Optional<MessageHandlingMember> handler = this.inspector.getHandlers(this.listenerType).filter(h -> h.canHandle(event, context)).findFirst();
        if (handler.isPresent()) {
            MessageHandlerInterceptorMemberChain<Object> interceptor = this.inspector.chainedInterceptor(this.listenerType);
            return interceptor.handleSync(event, context, this.annotatedEventListener, handler.get());
        }
        return null;
    }

    @Override
    public boolean canHandle(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        return this.inspector.getHandlers(this.listenerType).anyMatch(h -> h.canHandle(event, context));
    }

    @Override
    public boolean canHandleType(Class<?> payloadType) {
        return this.inspector.getHandlers(this.listenerType).filter(messageHandlingMember -> messageHandlingMember.canHandleMessageType(EventMessage.class)).anyMatch(handler -> handler.canHandleType(payloadType));
    }

    @Override
    public Class<?> getTargetType() {
        return this.listenerType;
    }

    @Override
    public void prepareReset(ProcessingContext context) {
        this.prepareReset(null, null);
    }

    @Override
    public <R> void prepareReset(R resetContext, ProcessingContext context) {
        try {
            ResetContext resetMessage = this.asResetContext(resetContext);
            LegacyMessageSupportingContext messageProcessingContext = new LegacyMessageSupportingContext(resetMessage);
            this.inspector.getHandlers(this.listenerType).filter(h -> h.canHandle(resetMessage, messageProcessingContext)).findFirst().ifPresent(messageHandlingMember -> messageHandlingMember.handle(resetMessage, messageProcessingContext, this.annotatedEventListener).first().asCompletableFuture().join());
        }
        catch (Exception e) {
            throw new ResetNotSupportedException("An Error occurred while notifying handlers of the reset", e);
        }
    }

    private <T> ResetContext<T> asResetContext(Object messageOrPayload) {
        if (messageOrPayload instanceof ResetContext) {
            return (ResetContext)messageOrPayload;
        }
        if (messageOrPayload instanceof Message) {
            return new GenericResetContext((Message)messageOrPayload);
        }
        MessageType type = messageOrPayload == null ? new MessageType("empty.reset.context") : this.messageTypeResolver.resolveOrThrow(messageOrPayload);
        return new GenericResetContext<Object>(type, messageOrPayload);
    }

    @Override
    public boolean supportsReset() {
        return this.inspector.getAllHandlers().values().stream().flatMap(Collection::stream).anyMatch(AnnotationEventHandlerAdapter::supportsReplay);
    }
}

