/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.axonframework.configuration.AbstractComponent;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentLifecycleHandler;
import org.axonframework.configuration.DecoratedComponent;
import org.axonframework.configuration.DecoratorDefinition;

class DefaultDecoratorDefinition<C, D extends C>
implements DecoratorDefinition.CompletedDecoratorDefinition<C, D> {
    private final Predicate<Component.Identifier<?>> selector;
    private final ComponentDecorator<C, D> decorator;
    private int order;
    private final List<AbstractComponent.HandlerRegistration<D>> startHandlers = new CopyOnWriteArrayList<AbstractComponent.HandlerRegistration<D>>();
    private final List<AbstractComponent.HandlerRegistration<D>> shutdownHandlers = new CopyOnWriteArrayList<AbstractComponent.HandlerRegistration<D>>();

    public DefaultDecoratorDefinition(@Nonnull Predicate<Component.Identifier<?>> selector, @Nonnull ComponentDecorator<C, D> decorator) {
        this.selector = Objects.requireNonNull(selector, "The selector must not be null.");
        this.decorator = Objects.requireNonNull(decorator, "The decorator must not be null.");
    }

    @Override
    public DecoratorDefinition<C, D> order(int order) {
        this.order = order;
        return this;
    }

    @Override
    public DecoratorDefinition<C, D> onStart(int phase, @Nonnull ComponentLifecycleHandler<D> handler) {
        this.startHandlers.add(new AbstractComponent.HandlerRegistration<D>(phase, handler));
        return this;
    }

    @Override
    public DecoratorDefinition<C, D> onShutdown(int phase, @Nonnull ComponentLifecycleHandler<D> handler) {
        this.shutdownHandlers.add(new AbstractComponent.HandlerRegistration<D>(phase, handler));
        return this;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public Component<C> decorate(@Nonnull Component<C> delegate) {
        return new DecoratedComponent<C, D>(delegate, this.decorator, this.startHandlers, this.shutdownHandlers);
    }

    @Override
    public boolean matches(@Nonnull Component.Identifier<?> id) {
        return this.selector.test(id);
    }
}

