/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class InterceptingCommandBus
implements CommandBus {
    private final CommandBus delegate;
    private final LinkedList<MessageHandlerInterceptor<? super CommandMessage<?>>> handlerInterceptors;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;
    private final BiFunction<CommandMessage<?>, ProcessingContext, MessageStream<CommandResultMessage<?>>> dispatcher;

    public InterceptingCommandBus(@Nonnull CommandBus delegate, @Nonnull List<MessageHandlerInterceptor<? super CommandMessage<?>>> handlerInterceptors, @Nonnull List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The command bus delegate must be null.");
        this.handlerInterceptors = new LinkedList(Objects.requireNonNull(handlerInterceptors, "The handler interceptors must not be null."));
        this.dispatchInterceptors = new ArrayList((Collection)Objects.requireNonNull(dispatchInterceptors, "The dispatch interceptors must not be null."));
        Iterator<MessageDispatchInterceptor<CommandMessage<?>>> di = new LinkedList(dispatchInterceptors).descendingIterator();
        Dispatcher dis = (c, p) -> MessageStream.fromFuture(delegate.dispatch((CommandMessage<?>)c, (ProcessingContext)p));
        while (di.hasNext()) {
            dis = new Dispatcher(di.next(), dis);
        }
        this.dispatcher = dis;
    }

    @Override
    public InterceptingCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        CommandHandler handler = Objects.requireNonNull(commandHandler, "The command handler cannot be null.");
        Iterator<MessageHandlerInterceptor<CommandMessage<?>>> iter = this.handlerInterceptors.descendingIterator();
        CommandHandler interceptedHandler = handler;
        while (iter.hasNext()) {
            interceptedHandler = new InterceptedHandler(iter.next(), interceptedHandler);
        }
        this.delegate.subscribe(name, interceptedHandler);
        return this;
    }

    @Override
    public CompletableFuture<CommandResultMessage<?>> dispatch(@Nonnull CommandMessage<?> command, @Nullable ProcessingContext processingContext) {
        return this.dispatcher.apply(Objects.requireNonNull(command, "The command message cannot be null."), processingContext).first().asCompletableFuture().thenApply(MessageStream.Entry::message);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("handlerInterceptors", this.handlerInterceptors);
        descriptor.describeProperty("dispatchInterceptors", this.dispatchInterceptors);
    }

    private record Dispatcher(MessageDispatchInterceptor<? super CommandMessage<?>> interceptor, BiFunction<CommandMessage<?>, ProcessingContext, MessageStream<CommandResultMessage<?>>> next) implements BiFunction<CommandMessage<?>, ProcessingContext, MessageStream<CommandResultMessage<?>>>,
    InterceptorChain<CommandMessage<?>, CommandResultMessage<?>>
    {
        @Override
        public MessageStream<CommandResultMessage<?>> apply(CommandMessage<?> commandMessage, ProcessingContext processingContext) {
            try {
                return this.interceptor.interceptOnDispatch(commandMessage, processingContext, this);
            }
            catch (RuntimeException e) {
                return MessageStream.failed(e);
            }
        }

        @Override
        public Object proceedSync(@Nonnull ProcessingContext context) {
            throw new UnsupportedOperationException("Sync processing not supported ");
        }

        @Override
        public MessageStream<CommandResultMessage<?>> proceed(@Nonnull CommandMessage<?> message, @Nonnull ProcessingContext context) {
            return this.next.apply(message, context);
        }
    }

    private record InterceptedHandler(MessageHandlerInterceptor<? super CommandMessage<?>> interceptor, CommandHandler next) implements CommandHandler,
    InterceptorChain<CommandMessage<?>, CommandResultMessage<?>>
    {
        @Override
        @Nonnull
        public MessageStream.Single<CommandResultMessage<?>> handle(@Nonnull CommandMessage<?> message, @Nonnull ProcessingContext processingContext) {
            try {
                return this.interceptor.interceptOnHandle(message, processingContext, this).first();
            }
            catch (RuntimeException e) {
                return MessageStream.failed(e);
            }
        }

        @Override
        public Object proceedSync(@Nonnull ProcessingContext context) {
            throw new UnsupportedOperationException("Sync processing not supported");
        }

        @Override
        public MessageStream<CommandResultMessage<?>> proceed(@Nonnull CommandMessage<?> message, @Nonnull ProcessingContext context) {
            return this.next.handle(message, context);
        }
    }
}

