/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.io.Serializable;
import java.util.function.UnaryOperator;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.AbstractCacheAdapter;
import org.axonframework.common.caching.Cache;

public class JCacheAdapter
extends AbstractCacheAdapter<CacheEntryListenerConfiguration<Object, Object>> {
    private final Cache<Object, Object> jCache;

    public JCacheAdapter(Cache<Object, Object> jCache) {
        this.jCache = jCache;
    }

    @Override
    public <K, V> V get(K key) {
        return (V)this.jCache.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.jCache.put(key, value);
    }

    @Override
    public boolean putIfAbsent(Object key, Object value) {
        return this.jCache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key) {
        return this.jCache.remove(key);
    }

    @Override
    public void removeAll() {
        this.jCache.removeAll();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.jCache.containsKey(key);
    }

    @Override
    public <V> void computeIfPresent(Object key, UnaryOperator<V> update) {
        Object newValue;
        Object oldValue;
        while ((oldValue = this.jCache.get(key)) != null && !this.replaceOrRemove(key, oldValue, newValue = update.apply(oldValue))) {
        }
    }

    private <V> boolean replaceOrRemove(Object key, Object oldValue, V newValue) {
        return newValue != null ? this.jCache.replace(key, oldValue, newValue) : this.jCache.remove(key);
    }

    @Override
    protected CacheEntryListenerConfiguration<Object, Object> createListenerAdapter(Cache.EntryListener cacheEntryListener) {
        return new JCacheListenerAdapter<Object, Object>(cacheEntryListener);
    }

    @Override
    protected Registration doRegisterListener(CacheEntryListenerConfiguration<Object, Object> listenerAdapter) {
        this.jCache.registerCacheEntryListener(listenerAdapter);
        return () -> {
            this.jCache.deregisterCacheEntryListener(listenerAdapter);
            return true;
        };
    }

    private static final class JCacheListenerAdapter<K, V>
    implements CacheEntryListenerConfiguration<K, V>,
    CacheEntryUpdatedListener<K, V>,
    CacheEntryCreatedListener<K, V>,
    CacheEntryExpiredListener<K, V>,
    CacheEntryRemovedListener<K, V>,
    Factory<CacheEntryListener<? super K, ? super V>>,
    Serializable {
        private static final long serialVersionUID = 3260575514029378445L;
        private final Cache.EntryListener delegate;

        public JCacheListenerAdapter(Cache.EntryListener delegate) {
            this.delegate = delegate;
        }

        public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
                this.delegate.onEntryCreated(cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }

        public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryExpired(cacheEntryEvent.getKey());
            }
        }

        public Factory<CacheEntryListener<? super K, ? super V>> getCacheEntryListenerFactory() {
            return this;
        }

        public boolean isOldValueRequired() {
            return false;
        }

        public Factory<CacheEntryEventFilter<? super K, ? super V>> getCacheEntryEventFilterFactory() {
            return null;
        }

        public boolean isSynchronous() {
            return true;
        }

        public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryRemoved(cacheEntryEvent.getKey());
            }
        }

        public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> iterable) throws CacheEntryListenerException {
            for (CacheEntryEvent<K, V> cacheEntryEvent : iterable) {
                this.delegate.onEntryUpdated(cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }

        public CacheEntryListener<K, V> create() {
            return this;
        }
    }
}

