/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.AxonNonTransientExceptionClassesPredicate;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryScheduler
implements RetryScheduler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_MAX_RETRIES = 1;
    private final ScheduledExecutorService retryExecutor;
    private final Predicate<Throwable> nonTransientFailurePredicate;
    private final int maxRetryCount;

    protected AbstractRetryScheduler(Builder builder) {
        builder.validate();
        this.retryExecutor = builder.retryExecutor;
        this.nonTransientFailurePredicate = builder.nonTransientFailurePredicate;
        this.maxRetryCount = builder.maxRetryCount;
    }

    protected boolean scheduleRetry(Runnable commandDispatch, long interval) {
        try {
            this.retryExecutor.schedule(commandDispatch, interval, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    protected abstract long computeRetryInterval(CommandMessage var1, RuntimeException var2, List<Class<? extends Throwable>[]> var3);

    protected boolean isExplicitlyNonTransient(Throwable failure) {
        boolean isNonTransientFailure = this.nonTransientFailurePredicate.test(failure);
        return isNonTransientFailure || failure.getCause() != null && this.isExplicitlyNonTransient(failure.getCause());
    }

    @Override
    public boolean scheduleRetry(@Nonnull CommandMessage commandMessage, @Nonnull RuntimeException lastFailure, @Nonnull List<Class<? extends Throwable>[]> failures, @Nonnull Runnable dispatchTask) {
        int failureCount = failures.size();
        if (!this.isExplicitlyNonTransient(lastFailure) && failureCount <= this.maxRetryCount) {
            if (logger.isInfoEnabled()) {
                logger.info("Processing of Command [{}] resulted in an exception. Will retry {} more time(s)... Exception was {}, {}", new Object[]{commandMessage.getPayloadType().getSimpleName(), this.maxRetryCount - failureCount, lastFailure.getClass().getName(), lastFailure.getMessage()});
            }
            return this.scheduleRetry(dispatchTask, this.computeRetryInterval(commandMessage, lastFailure, failures));
        }
        if (failureCount >= this.maxRetryCount && logger.isInfoEnabled()) {
            logger.warn("Processing of Command [{}] resulted in an exception {} times. Giving up permanently.", new Object[]{commandMessage.getPayloadType().getSimpleName(), failureCount, lastFailure});
        } else if (logger.isInfoEnabled()) {
            logger.debug("Processing of Command [{}] resulted in an exception and will not be retried. Exception was {}, {}", new Object[]{commandMessage.getPayloadType().getSimpleName(), lastFailure.getClass().getName(), lastFailure.getMessage()});
        }
        return false;
    }

    public static abstract class Builder<B extends Builder> {
        private ScheduledExecutorService retryExecutor;
        private int maxRetryCount = 1;
        private Predicate<Throwable> nonTransientFailurePredicate = new AxonNonTransientExceptionClassesPredicate();

        public B retryExecutor(@Nonnull ScheduledExecutorService retryExecutor) {
            BuilderUtils.assertNonNull(retryExecutor, "ScheduledExecutorService may not be null");
            this.retryExecutor = retryExecutor;
            return (B)this;
        }

        public B nonTransientFailurePredicate(@Nonnull Predicate<Throwable> nonTransientFailurePredicate) {
            BuilderUtils.assertNonNull(nonTransientFailurePredicate, "Non-transient failure predicate may not be null");
            this.nonTransientFailurePredicate = nonTransientFailurePredicate;
            return (B)this;
        }

        public <E extends Throwable> B nonTransientFailurePredicate(@Nonnull Class<E> failureType, @Nonnull Predicate<? super E> nonTransientFailurePredicate) {
            BuilderUtils.assertNonNull(failureType, "Class of failure type may not be null");
            BuilderUtils.assertNonNull(nonTransientFailurePredicate, "Non-transient failure predicate may not be null");
            Predicate<Throwable> typeCheckPredicate = failureAtRuntime -> failureType.isInstance(failureAtRuntime);
            this.nonTransientFailurePredicate = typeCheckPredicate.and(nonTransientFailurePredicate);
            return (B)this;
        }

        public B addNonTransientFailurePredicate(@Nonnull Predicate<Throwable> nonTransientFailurePredicate) {
            BuilderUtils.assertNonNull(nonTransientFailurePredicate, "Non-transient failure predicate may not be null");
            this.nonTransientFailurePredicate = nonTransientFailurePredicate.or(this.nonTransientFailurePredicate);
            return (B)this;
        }

        public <E extends Throwable> B addNonTransientFailurePredicate(@Nonnull Class<E> failureType, @Nonnull Predicate<? super E> nonTransientFailurePredicate) {
            BuilderUtils.assertNonNull(failureType, "Class of failure type may not be null");
            BuilderUtils.assertNonNull(nonTransientFailurePredicate, "Non-transient failure predicate may not be null");
            Predicate<Throwable> typeCheckPredicate = failureAtRuntime -> failureType.isInstance(failureAtRuntime);
            Predicate<E> typeCheckingNonTransientFailurePredicate = typeCheckPredicate.and(nonTransientFailurePredicate);
            this.nonTransientFailurePredicate = typeCheckingNonTransientFailurePredicate.or(this.nonTransientFailurePredicate);
            return (B)this;
        }

        public B maxRetryCount(int maxRetryCount) {
            BuilderUtils.assertStrictPositive(maxRetryCount, "The maxRetryCount must be a positive number");
            this.maxRetryCount = maxRetryCount;
            return (B)this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.retryExecutor, "The ScheduledExecutorService is a hard requirement and should be provided");
        }
    }
}

