/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.lifecycle;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface Lifecycle {
    public void registerLifecycleHandlers(@Nonnull LifecycleRegistry var1);

    @FunctionalInterface
    public static interface LifecycleHandler {
        public CompletableFuture<Void> run();
    }

    public static interface LifecycleRegistry {
        default public void onStart(int phase, @Nonnull Runnable action) {
            this.onStart(phase, () -> {
                try {
                    action.run();
                    return CompletableFuture.completedFuture(null);
                }
                catch (Exception e) {
                    CompletableFuture cf = new CompletableFuture();
                    cf.completeExceptionally(e);
                    return cf;
                }
            });
        }

        default public void onShutdown(int phase, @Nonnull Runnable action) {
            this.onShutdown(phase, () -> {
                try {
                    action.run();
                    return CompletableFuture.completedFuture(null);
                }
                catch (Exception e) {
                    CompletableFuture cf = new CompletableFuture();
                    cf.completeExceptionally(e);
                    return cf;
                }
            });
        }

        public void onStart(int var1, @Nonnull LifecycleHandler var2);

        public void onShutdown(int var1, @Nonnull LifecycleHandler var2);
    }
}

