/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.concurrent.Callable;
import java.util.function.Supplier;

public interface Span {
    public Span start();

    public void end();

    public Span recordException(Throwable var1);

    default public void run(Runnable runnable) {
        try {
            this.start();
            runnable.run();
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
        finally {
            this.end();
        }
    }

    default public Runnable wrapRunnable(Runnable runnable) {
        return () -> this.run(runnable);
    }

    default public <T> T runCallable(Callable<T> callable) throws Exception {
        try {
            this.start();
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
        finally {
            this.end();
        }
    }

    default public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return () -> this.runCallable(callable);
    }

    default public <T> T runSupplier(Supplier<T> supplier) {
        try {
            this.start();
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            this.recordException(e);
            throw e;
        }
        finally {
            this.end();
        }
    }

    default public <T> Supplier<T> wrapSupplier(Supplier<T> supplier) {
        return () -> this.runSupplier(supplier);
    }
}

