/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToRetrieveIdentifierException;

public interface TokenStore {
    default public void initializeTokenSegments(@Nonnull String processorName, int segmentCount) throws UnableToClaimTokenException {
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.fetchToken(processorName, segment);
            this.releaseClaim(processorName, segment);
        }
    }

    default public void initializeTokenSegments(@Nonnull String processorName, int segmentCount, @Nullable TrackingToken initialToken) throws UnableToClaimTokenException {
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.storeToken(initialToken, processorName, segment);
            this.releaseClaim(processorName, segment);
        }
    }

    public void storeToken(@Nullable TrackingToken var1, @Nonnull String var2, int var3) throws UnableToClaimTokenException;

    public TrackingToken fetchToken(@Nonnull String var1, int var2) throws UnableToClaimTokenException;

    default public TrackingToken fetchToken(@Nonnull String processorName, @Nonnull Segment segment) throws UnableToClaimTokenException {
        return this.fetchToken(processorName, segment.getSegmentId());
    }

    default public void extendClaim(@Nonnull String processorName, int segment) throws UnableToClaimTokenException {
        this.fetchToken(processorName, segment);
    }

    public void releaseClaim(@Nonnull String var1, int var2);

    default public void initializeSegment(@Nullable TrackingToken token, @Nonnull String processorName, int segment) throws UnableToInitializeTokenException {
        throw new UnsupportedOperationException("Explicit initialization is not supported by this TokenStore implementation");
    }

    default public void deleteToken(@Nonnull String processorName, int segment) throws UnableToClaimTokenException {
        throw new UnsupportedOperationException("Explicit initialization (which is required to reliably delete tokens) is not supported by this TokenStore implementation");
    }

    default public boolean requiresExplicitSegmentInitialization() {
        return false;
    }

    public int[] fetchSegments(@Nonnull String var1);

    default public List<Segment> fetchAvailableSegments(@Nonnull String processorName) {
        int[] allSegments = this.fetchSegments(processorName);
        return Arrays.stream(allSegments).boxed().map(segment -> Segment.computeSegment(segment, allSegments)).collect(Collectors.toList());
    }

    default public Optional<String> retrieveStorageIdentifier() throws UnableToRetrieveIdentifierException {
        return Optional.empty();
    }
}

