/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterJpaConverter;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

public class EventMessageDeadLetterJpaConverter
implements DeadLetterJpaConverter<EventMessage<?>> {
    @Override
    public DeadLetterEventEntry convert(EventMessage<?> message, Serializer serializer) {
        GenericEventMessage eventMessage = (GenericEventMessage)message;
        Optional<TrackedEventMessage> trackedEventMessage = Optional.of(eventMessage).filter(TrackedEventMessage.class::isInstance).map(TrackedEventMessage.class::cast);
        Optional<DomainEventMessage> domainEventMessage = Optional.of(eventMessage).filter(DomainEventMessage.class::isInstance).map(DomainEventMessage.class::cast);
        SerializedObject<byte[]> serializedPayload = serializer.serialize(message.getPayload(), byte[].class);
        SerializedObject<byte[]> serializedMetadata = serializer.serialize(message.getMetaData(), byte[].class);
        Optional<SerializedObject> serializedToken = trackedEventMessage.map(m -> serializer.serialize(m.trackingToken(), byte[].class));
        return new DeadLetterEventEntry(message.getClass().getName(), message.getIdentifier(), message.getTimestamp().toString(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedPayload.getData(), serializedMetadata.getData(), domainEventMessage.map(DomainEventMessage::getType).orElse(null), domainEventMessage.map(DomainEventMessage::getAggregateIdentifier).orElse(null), domainEventMessage.map(DomainEventMessage::getSequenceNumber).orElse(null), serializedToken.map(SerializedObject::getType).map(SerializedType::getName).orElse(null), serializedToken.map(SerializedObject::getData).orElse(null));
    }

    @Override
    public EventMessage<?> convert(DeadLetterEventEntry entry, Serializer serializer) {
        SerializedMessage serializedMessage = new SerializedMessage(entry.getEventIdentifier(), entry.getPayload(), entry.getMetaData(), serializer);
        Supplier<Instant> timestampSupplier = () -> Instant.parse(entry.getTimeStamp());
        if (entry.getTrackingToken() != null) {
            TrackingToken trackingToken = (TrackingToken)serializer.deserialize(entry.getTrackingToken());
            if (entry.getAggregateIdentifier() != null) {
                return new GenericTrackedDomainEventMessage(trackingToken, entry.getType(), entry.getAggregateIdentifier(), (long)entry.getSequenceNumber(), serializedMessage, timestampSupplier);
            }
            return new GenericTrackedEventMessage(trackingToken, serializedMessage, timestampSupplier);
        }
        if (entry.getAggregateIdentifier() != null) {
            return new GenericDomainEventMessage(entry.getType(), entry.getAggregateIdentifier(), entry.getSequenceNumber(), serializedMessage.getPayload(), serializedMessage.getMetaData(), serializedMessage.getIdentifier(), timestampSupplier.get());
        }
        return new GenericEventMessage(serializedMessage, timestampSupplier);
    }

    @Override
    public boolean canConvert(DeadLetterEventEntry message) {
        return message.getMessageType().equals(GenericTrackedDomainEventMessage.class.getName()) || message.getMessageType().equals(GenericEventMessage.class.getName()) || message.getMessageType().equals(GenericDomainEventMessage.class.getName()) || message.getMessageType().equals(GenericTrackedEventMessage.class.getName());
    }

    @Override
    public boolean canConvert(EventMessage<?> message) {
        return message instanceof GenericEventMessage;
    }
}

