/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.RoutingKey;
import org.axonframework.commandhandling.distributed.AbstractRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.commandhandling.distributed.UnresolvedRoutingKeyPolicy;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;

public class AnnotationRoutingStrategy
extends AbstractRoutingStrategy {
    private static final RoutingKeyResolver NO_RESOLVE = new RoutingKeyResolver((Method)null);
    private static final String NULL_DEFAULT = null;
    private final Class<? extends Annotation> annotationType;
    private final Map<Class<?>, RoutingKeyResolver> resolverMap = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    public static AnnotationRoutingStrategy defaultStrategy() {
        return AnnotationRoutingStrategy.builder().build();
    }

    protected AnnotationRoutingStrategy(Builder builder) {
        super(builder.fallbackRoutingStrategy);
        builder.validate();
        this.annotationType = builder.annotationType;
    }

    @Deprecated
    public AnnotationRoutingStrategy() {
        this(RoutingKey.class);
    }

    @Deprecated
    public AnnotationRoutingStrategy(Class<? extends Annotation> annotationType) {
        this(annotationType, UnresolvedRoutingKeyPolicy.ERROR);
    }

    @Deprecated
    public AnnotationRoutingStrategy(UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        this(RoutingKey.class, unresolvedRoutingKeyPolicy);
    }

    @Deprecated
    public AnnotationRoutingStrategy(Class<? extends Annotation> annotationType, UnresolvedRoutingKeyPolicy unresolvedRoutingKeyPolicy) {
        super(unresolvedRoutingKeyPolicy);
        this.annotationType = annotationType;
    }

    @Override
    protected String doResolveRoutingKey(CommandMessage<?> command) {
        String routingKey;
        try {
            routingKey = this.findIdentifier(command);
        }
        catch (InvocationTargetException e) {
            throw new AxonConfigurationException("An exception occurred while extracting routing information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new AxonConfigurationException("The current security context does not allow extraction of routing information from the given command.", e);
        }
        return routingKey;
    }

    private String findIdentifier(CommandMessage<?> command) throws InvocationTargetException, IllegalAccessException {
        return this.resolverMap.computeIfAbsent(command.getPayloadType(), this::createResolver).identify(command.getPayload());
    }

    private RoutingKeyResolver createResolver(Class<?> type) {
        for (Method m : ReflectionUtils.methodsOf(type)) {
            if (!AnnotationUtils.findAnnotationAttributes((AnnotatedElement)m, this.annotationType).isPresent()) continue;
            ReflectionUtils.ensureAccessible(m);
            return new RoutingKeyResolver(m);
        }
        for (Field f : ReflectionUtils.fieldsOf(type)) {
            if (!AnnotationUtils.findAnnotationAttributes((AnnotatedElement)f, this.annotationType).isPresent()) continue;
            return new RoutingKeyResolver(f);
        }
        return NO_RESOLVE;
    }

    public static class Builder {
        private Class<? extends Annotation> annotationType = RoutingKey.class;
        private RoutingStrategy fallbackRoutingStrategy = UnresolvedRoutingKeyPolicy.RANDOM_KEY;

        public Builder fallbackRoutingStrategy(RoutingStrategy fallbackRoutingStrategy) {
            BuilderUtils.assertNonNull(fallbackRoutingStrategy, "Fallback RoutingStrategy may not be null");
            this.fallbackRoutingStrategy = fallbackRoutingStrategy;
            return this;
        }

        public Builder annotationType(Class<? extends Annotation> annotationType) {
            BuilderUtils.assertNonNull(annotationType, "AnnotationType may not be null");
            this.annotationType = annotationType;
            return this;
        }

        public AnnotationRoutingStrategy build() {
            return new AnnotationRoutingStrategy(this);
        }

        protected void validate() {
        }
    }

    private static final class RoutingKeyResolver {
        private final Method method;
        private final Field field;

        public RoutingKeyResolver(Method method) {
            this.method = method;
            this.field = null;
        }

        public RoutingKeyResolver(Field field) {
            this.method = null;
            this.field = field;
        }

        public String identify(Object command) throws InvocationTargetException, IllegalAccessException {
            if (this.method != null) {
                return Objects.toString(this.method.invoke(command, new Object[0]), NULL_DEFAULT);
            }
            if (this.field != null) {
                return Objects.toString(ReflectionUtils.getFieldValue(this.field, command), NULL_DEFAULT);
            }
            return null;
        }
    }
}

