/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.FailureLoggingCallback;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.gateway.AbstractCommandGateway;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandGateway
extends AbstractCommandGateway
implements CommandGateway {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandGateway.class);

    protected DefaultCommandGateway(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <C, R> void send(C command, CommandCallback<? super C, ? super R> callback) {
        super.send(command, callback);
    }

    @Override
    public <R> R sendAndWait(Object command) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        CommandResultMessage commandResultMessage = futureCallback.getResult();
        if (commandResultMessage.isExceptional()) {
            throw this.asRuntime(commandResultMessage.exceptionResult());
        }
        return (R)commandResultMessage.getPayload();
    }

    @Override
    public <R> R sendAndWait(Object command, long timeout, TimeUnit unit) {
        FutureCallback futureCallback = new FutureCallback();
        this.send(command, futureCallback);
        CommandResultMessage commandResultMessage = futureCallback.getResult(timeout, unit);
        if (commandResultMessage.isExceptional()) {
            throw this.asRuntime(commandResultMessage.exceptionResult());
        }
        return (R)commandResultMessage.getPayload();
    }

    @Override
    public <R> CompletableFuture<R> send(Object command) {
        FutureCallback callback = new FutureCallback();
        this.send(command, new FailureLoggingCallback(logger, callback));
        CompletableFuture result = new CompletableFuture();
        ((CompletableFuture)callback.exceptionally(GenericCommandResultMessage::asCommandResultMessage)).thenAccept(r -> {
            try {
                if (r.isExceptional()) {
                    result.completeExceptionally(r.exceptionResult());
                } else {
                    result.complete(r.getPayload());
                }
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return super.registerDispatchInterceptor(dispatchInterceptor);
    }

    private RuntimeException asRuntime(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new CommandExecutionException("An exception occurred while executing a command", e);
    }

    public static class Builder
    extends AbstractCommandGateway.Builder {
        @Override
        public Builder commandBus(CommandBus commandBus) {
            super.commandBus(commandBus);
            return this;
        }

        @Override
        public Builder retryScheduler(RetryScheduler retryScheduler) {
            super.retryScheduler(retryScheduler);
            return this;
        }

        @Override
        public Builder dispatchInterceptors(MessageDispatchInterceptor<? super CommandMessage<?>> ... dispatchInterceptors) {
            super.dispatchInterceptors(dispatchInterceptors);
            return this;
        }

        @Override
        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
            super.dispatchInterceptors(dispatchInterceptors);
            return this;
        }

        public DefaultCommandGateway build() {
            return new DefaultCommandGateway(this);
        }
    }
}

