/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Objects;
import java.util.OptionalLong;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;

public interface EventTrackerStatus {
    public Segment getSegment();

    public boolean isCaughtUp();

    public boolean isReplaying();

    public boolean isMerging();

    public OptionalLong mergeCompletedPosition();

    public TrackingToken getTrackingToken();

    public boolean isErrorState();

    public Throwable getError();

    public OptionalLong getCurrentPosition();

    public OptionalLong getResetPosition();

    default public boolean trackerAdded() {
        return false;
    }

    default public boolean trackerRemoved() {
        return false;
    }

    default public boolean isDifferent(EventTrackerStatus that) {
        return this.isDifferent(that, true);
    }

    default public boolean isDifferent(EventTrackerStatus that, boolean validatePositions) {
        if (this == that) {
            return false;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return true;
        }
        boolean matchingStates = this.matchStates(that);
        boolean matchingPositions = !validatePositions || this.matchPositions(that);
        return !matchingStates || !matchingPositions;
    }

    default public boolean matchStates(EventTrackerStatus that) {
        return Objects.equals(this.isCaughtUp(), that.isCaughtUp()) && Objects.equals(this.isReplaying(), that.isReplaying()) && Objects.equals(this.isMerging(), that.isMerging()) && Objects.equals(this.isErrorState(), that.isErrorState());
    }

    default public boolean matchPositions(EventTrackerStatus that) {
        return Objects.equals(this.getCurrentPosition(), that.getCurrentPosition()) && Objects.equals(this.getResetPosition(), that.getResetPosition()) && Objects.equals(this.mergeCompletedPosition(), that.mergeCompletedPosition());
    }
}

