/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.callbacks.FutureCallback;
import org.axonframework.commandhandling.gateway.AbstractCommandGateway;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.Timeout;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.responsetypes.ResponseType;

public class CommandGatewayFactory {
    private final CommandBus commandBus;
    private final RetryScheduler retryScheduler;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;
    private final List<CommandCallback<?, ?>> commandCallbacks;

    protected CommandGatewayFactory(Builder builder) {
        builder.validate();
        this.commandBus = builder.commandBus;
        this.retryScheduler = builder.retryScheduler;
        this.dispatchInterceptors = builder.dispatchInterceptors != null && !builder.dispatchInterceptors.isEmpty() ? new CopyOnWriteArrayList(builder.dispatchInterceptors) : new CopyOnWriteArrayList();
        this.commandCallbacks = new CopyOnWriteArrayList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T createGateway(Class<T> gatewayInterface) {
        HashMap<Method, InvocationHandler> dispatchers = new HashMap<Method, InvocationHandler>();
        for (Method gatewayMethod : gatewayInterface.getMethods()) {
            MetaDataExtractor[] extractors = this.extractMetaData(gatewayMethod.getParameters());
            Class<?>[] arguments = gatewayMethod.getParameterTypes();
            InvocationHandler dispatcher = ((DispatchOnInvocationHandler.Builder)DispatchOnInvocationHandler.builder().commandBus(this.commandBus).retryScheduler(this.retryScheduler).dispatchInterceptors((List)this.dispatchInterceptors)).metaDataExtractors(extractors).commandCallbacks(this.commandCallbacks).forceCallbacks(true).build();
            if (!Arrays.asList(CompletableFuture.class, Future.class, CompletionStage.class).contains(gatewayMethod.getReturnType())) {
                if (arguments.length >= 3 && TimeUnit.class.isAssignableFrom(arguments[arguments.length - 1]) && (Long.TYPE.isAssignableFrom(arguments[arguments.length - 2]) || Integer.TYPE.isAssignableFrom(arguments[arguments.length - 2]))) {
                    dispatcher = this.wrapToReturnWithTimeoutInArguments(dispatcher, arguments.length - 2, arguments.length - 1);
                } else {
                    Map timeout = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)gatewayMethod, Timeout.class).orElse(AnnotationUtils.findAnnotationAttributes(gatewayMethod.getDeclaringClass(), Timeout.class).orElse(null));
                    if (timeout != null) {
                        dispatcher = this.wrapToReturnWithFixedTimeout(dispatcher, ((Integer)timeout.get("timeout")).intValue(), (TimeUnit)((Object)timeout.get("unit")));
                    } else if (!Void.TYPE.equals(gatewayMethod.getReturnType()) || gatewayMethod.getExceptionTypes().length > 0) {
                        dispatcher = this.wrapToWaitForResult(dispatcher);
                    } else if (this.commandCallbacks.isEmpty() && !this.hasCallbackParameters(gatewayMethod)) {
                        DispatchOnInvocationHandler fireAndForgetHandler = ((DispatchOnInvocationHandler.Builder)DispatchOnInvocationHandler.builder().commandBus(this.commandBus).retryScheduler(this.retryScheduler).dispatchInterceptors((List)this.dispatchInterceptors)).metaDataExtractors(extractors).commandCallbacks(this.commandCallbacks).forceCallbacks(false).build();
                        dispatcher = this.wrapToFireAndForget(fireAndForgetHandler);
                    }
                }
                Class<?>[] declaredExceptions = gatewayMethod.getExceptionTypes();
                dispatcher = this.wrapUndeclaredExceptions(dispatcher, declaredExceptions);
            }
            dispatchers.put(gatewayMethod, dispatcher);
        }
        GatewayInvocationHandler gatewayInvocationHandler = ((GatewayInvocationHandler.Builder)GatewayInvocationHandler.builder().commandBus(this.commandBus).retryScheduler(this.retryScheduler).dispatchInterceptors((List)this.dispatchInterceptors)).dispatchers(dispatchers).build();
        return gatewayInterface.cast(Proxy.newProxyInstance(gatewayInterface.getClassLoader(), new Class[]{gatewayInterface}, (java.lang.reflect.InvocationHandler)gatewayInvocationHandler));
    }

    private boolean hasCallbackParameters(Method gatewayMethod) {
        return Stream.of(gatewayMethod.getParameterTypes()).anyMatch(CommandCallback.class::isAssignableFrom);
    }

    protected <R> InvocationHandler<R> wrapUndeclaredExceptions(InvocationHandler<R> delegate, Class<?>[] declaredExceptions) {
        return new WrapNonDeclaredCheckedExceptions(delegate, declaredExceptions);
    }

    protected <R> InvocationHandler<R> wrapToFireAndForget(InvocationHandler<CompletableFuture<R>> delegate) {
        return new FireAndForget(delegate);
    }

    protected <R> InvocationHandler<R> wrapToWaitForResult(InvocationHandler<CompletableFuture<R>> delegate) {
        return new WaitForResult(delegate);
    }

    protected <R> InvocationHandler<R> wrapToReturnWithFixedTimeout(InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
        return new WaitForResultWithFixedTimeout(delegate, timeout, timeUnit);
    }

    protected <R> InvocationHandler<R> wrapToReturnWithTimeoutInArguments(InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
        return new WaitForResultWithTimeoutInArguments(delegate, timeoutIndex, timeUnitIndex);
    }

    private boolean contains(Class<?>[] declaredExceptions, Class<?> exceptionClass) {
        return Stream.of(declaredExceptions).anyMatch(declaredException -> declaredException.isAssignableFrom(exceptionClass));
    }

    public <C, R> CommandGatewayFactory registerCommandCallback(CommandCallback<C, R> callback, ResponseType<R> responseType) {
        this.commandCallbacks.add(new TypeSafeCallbackWrapper<C, R>(callback, responseType));
        return this;
    }

    public CommandGatewayFactory registerDispatchInterceptor(MessageDispatchInterceptor<CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return this;
    }

    private MetaDataExtractor[] extractMetaData(Parameter[] parameters) {
        ArrayList<MetaDataExtractor> extractors = new ArrayList<MetaDataExtractor>();
        for (int i = 0; i < parameters.length; ++i) {
            if (MetaData.class.isAssignableFrom(parameters[i].getType())) {
                extractors.add(new MetaDataExtractor(i, null));
                continue;
            }
            Optional<Map<String, Object>> metaDataAnnotation = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameters[i], MetaDataValue.class);
            if (!metaDataAnnotation.isPresent()) continue;
            extractors.add(new MetaDataExtractor(i, (String)metaDataAnnotation.get().get("metaDataValue")));
        }
        return extractors.toArray(new MetaDataExtractor[0]);
    }

    public static class Builder {
        private CommandBus commandBus;
        private RetryScheduler retryScheduler;
        private List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors;

        public Builder commandBus(CommandBus commandBus) {
            BuilderUtils.assertNonNull(commandBus, "CommandBus may not be null");
            this.commandBus = commandBus;
            return this;
        }

        public Builder retryScheduler(RetryScheduler retryScheduler) {
            this.retryScheduler = retryScheduler;
            return this;
        }

        public Builder dispatchInterceptors(MessageDispatchInterceptor<? super CommandMessage<?>> ... dispatchInterceptors) {
            return this.dispatchInterceptors(Arrays.asList(dispatchInterceptors));
        }

        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
            this.dispatchInterceptors = dispatchInterceptors;
            return this;
        }

        public CommandGatewayFactory build() {
            return new CommandGatewayFactory(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.commandBus, "The CommandBus is a hard requirement and should be provided");
        }
    }

    private static class TypeSafeCallbackWrapper<C, R>
    implements CommandCallback<C, R> {
        private final CommandCallback<C, R> delegate;
        private final ResponseType<R> parameterType;

        public TypeSafeCallbackWrapper(CommandCallback<C, R> delegate, ResponseType<R> responseType) {
            this.delegate = delegate;
            this.parameterType = responseType;
        }

        @Override
        public void onResult(CommandMessage<? extends C> commandMessage, CommandResultMessage<? extends R> commandResultMessage) {
            if (commandResultMessage.isExceptional() || this.parameterType.matches(commandResultMessage.getPayloadType())) {
                this.delegate.onResult(commandMessage, commandResultMessage);
            }
        }
    }

    private static class MetaDataExtractor {
        private final int argumentIndex;
        private final String metaDataKey;

        private MetaDataExtractor(int argumentIndex, String metaDataKey) {
            this.argumentIndex = argumentIndex;
            this.metaDataKey = metaDataKey;
        }

        public void addMetaData(Object[] args, Map<String, Object> metaData) {
            Object parameterValue = args[this.argumentIndex];
            if (this.metaDataKey == null) {
                if (parameterValue != null) {
                    metaData.putAll((Map)parameterValue);
                }
            } else {
                metaData.put(this.metaDataKey, parameterValue);
            }
        }
    }

    private static class FireAndForget<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;

        private FireAndForget(InvocationHandler<CompletableFuture<R>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            this.delegate.invoke(proxy, invokedMethod, args);
            return null;
        }
    }

    private static class WaitForResult<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;

        private WaitForResult(InvocationHandler<CompletableFuture<R>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get();
        }
    }

    private static class WaitForResultWithTimeoutInArguments<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;
        private final int timeoutIndex;
        private final int timeUnitIndex;

        private WaitForResultWithTimeoutInArguments(InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            this.delegate = delegate;
            this.timeoutIndex = timeoutIndex;
            this.timeUnitIndex = timeUnitIndex;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get(this.toLong(args[this.timeoutIndex]), (TimeUnit)((Object)args[this.timeUnitIndex]));
        }

        private long toLong(Object arg) {
            if (Integer.TYPE.isInstance(arg) || Integer.class.isInstance(arg)) {
                return ((Integer)arg).intValue();
            }
            return (Long)arg;
        }
    }

    private static class WaitForResultWithFixedTimeout<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<CompletableFuture<R>> delegate;
        private final long timeout;
        private final TimeUnit timeUnit;

        private WaitForResultWithFixedTimeout(InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
            this.delegate = delegate;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            return this.delegate.invoke(proxy, invokedMethod, args).get(this.timeout, this.timeUnit);
        }
    }

    private static class NullOnInterrupted<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<R> delegate;

        private NullOnInterrupted(InvocationHandler<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (InterruptedException timeout) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }

    private static class NullOnTimeout<R>
    implements InvocationHandler<R> {
        private final InvocationHandler<R> delegate;

        private NullOnTimeout(InvocationHandler<R> delegate) {
            this.delegate = delegate;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (TimeoutException timeout) {
                return null;
            }
        }
    }

    private static final class WrapNonDeclaredCheckedExceptions<R>
    implements InvocationHandler<R> {
        private final Class<?>[] declaredExceptions;
        private final InvocationHandler<R> delegate;

        private WrapNonDeclaredCheckedExceptions(InvocationHandler<R> delegate, Class<?>[] declaredExceptions) {
            this.delegate = delegate;
            this.declaredExceptions = declaredExceptions;
        }

        @Override
        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            try {
                return this.delegate.invoke(proxy, invokedMethod, args);
            }
            catch (ExecutionException e) {
                throw e.getCause() instanceof Exception ? this.asRuntimeIfNotDeclared((Exception)e.getCause()) : this.asRuntimeIfNotDeclared(e);
            }
            catch (Exception e) {
                throw this.asRuntimeIfNotDeclared(e);
            }
        }

        private Exception asRuntimeIfNotDeclared(Exception e) throws Exception {
            if (e instanceof RuntimeException) {
                return e;
            }
            for (Class<?> exception : this.declaredExceptions) {
                if (!exception.isInstance(e)) continue;
                throw e;
            }
            return new CommandExecutionException("Command execution resulted in a checked exception that was not declared on the gateway", e);
        }
    }

    private static class CompositeCallback<C, R>
    implements CommandCallback<C, R> {
        private final List<CommandCallback<? super C, ? super R>> callbacks;

        public CompositeCallback(List<CommandCallback<? super C, ? super R>> callbacks) {
            this.callbacks = new ArrayList<CommandCallback<C, R>>(callbacks);
        }

        @Override
        public void onResult(CommandMessage<? extends C> commandMessage, CommandResultMessage<? extends R> commandResultMessage) {
            this.callbacks.forEach(callback -> callback.onResult(commandMessage, commandResultMessage));
        }
    }

    private static class DispatchOnInvocationHandler<C, R>
    extends AbstractCommandGateway
    implements InvocationHandler<CompletableFuture<R>> {
        private final MetaDataExtractor[] metaDataExtractors;
        private final List<CommandCallback<? super C, ? super R>> commandCallbacks;
        private final boolean forceCallbacks;

        protected DispatchOnInvocationHandler(Builder builder) {
            super(builder);
            this.metaDataExtractors = builder.metaDataExtractors;
            this.commandCallbacks = builder.commandCallbacks;
            this.forceCallbacks = builder.forceCallbacks;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public CompletableFuture<R> invoke(Object proxy, Method invokedMethod, Object[] args) {
            Object command = args[0];
            if (this.metaDataExtractors.length != 0) {
                HashMap<String, Object> metaDataValues = new HashMap<String, Object>();
                for (MetaDataExtractor extractor : this.metaDataExtractors) {
                    extractor.addMetaData(args, metaDataValues);
                }
                if (!metaDataValues.isEmpty()) {
                    command = GenericCommandMessage.asCommandMessage(command).withMetaData(metaDataValues);
                }
            }
            if (this.forceCallbacks || !this.commandCallbacks.isEmpty()) {
                LinkedList callbacks = new LinkedList();
                FutureCallback future = new FutureCallback();
                callbacks.add(future);
                for (Object arg : args) {
                    if (!(arg instanceof CommandCallback)) continue;
                    CommandCallback callback = (CommandCallback)arg;
                    callbacks.add(callback);
                }
                callbacks.addAll(this.commandCallbacks);
                this.send(command, new CompositeCallback(callbacks));
                return future.thenCompose(reply -> {
                    if (reply.isExceptional()) {
                        CompletableFuture r = new CompletableFuture();
                        r.completeExceptionally(reply.exceptionResult());
                        return r;
                    }
                    return CompletableFuture.completedFuture(reply.getPayload());
                });
            }
            this.sendAndForget(command);
            return null;
        }

        private static class Builder<C, R>
        extends AbstractCommandGateway.Builder {
            private MetaDataExtractor[] metaDataExtractors;
            private List<CommandCallback<? super C, ? super R>> commandCallbacks;
            private boolean forceCallbacks;

            private Builder() {
            }

            @Override
            public Builder commandBus(CommandBus commandBus) {
                super.commandBus(commandBus);
                return this;
            }

            @Override
            public Builder retryScheduler(RetryScheduler retryScheduler) {
                super.retryScheduler(retryScheduler);
                return this;
            }

            @Override
            public Builder dispatchInterceptors(MessageDispatchInterceptor<? super CommandMessage<?>> ... dispatchInterceptors) {
                super.dispatchInterceptors(dispatchInterceptors);
                return this;
            }

            @Override
            public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
                super.dispatchInterceptors(dispatchInterceptors);
                return this;
            }

            public Builder metaDataExtractors(MetaDataExtractor[] metaDataExtractors) {
                this.metaDataExtractors = metaDataExtractors;
                return this;
            }

            public Builder commandCallbacks(List<CommandCallback<? super C, ? super R>> commandCallbacks) {
                this.commandCallbacks = commandCallbacks;
                return this;
            }

            public Builder forceCallbacks(boolean forceCallbacks) {
                this.forceCallbacks = forceCallbacks;
                return this;
            }

            public DispatchOnInvocationHandler build() {
                return new DispatchOnInvocationHandler(this);
            }
        }
    }

    private static class GatewayInvocationHandler
    extends AbstractCommandGateway
    implements java.lang.reflect.InvocationHandler {
        private final Map<Method, InvocationHandler> dispatchers;

        protected GatewayInvocationHandler(Builder builder) {
            super(builder);
            this.dispatchers = builder.dispatchers;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            InvocationHandler invocationHandler = this.dispatchers.get(method);
            return invocationHandler.invoke(proxy, method, args);
        }

        private static class Builder
        extends AbstractCommandGateway.Builder {
            private Map<Method, InvocationHandler> dispatchers;

            private Builder() {
            }

            @Override
            public Builder commandBus(CommandBus commandBus) {
                super.commandBus(commandBus);
                return this;
            }

            @Override
            public Builder retryScheduler(RetryScheduler retryScheduler) {
                super.retryScheduler(retryScheduler);
                return this;
            }

            @Override
            public Builder dispatchInterceptors(MessageDispatchInterceptor<? super CommandMessage<?>> ... dispatchInterceptors) {
                super.dispatchInterceptors(dispatchInterceptors);
                return this;
            }

            @Override
            public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors) {
                super.dispatchInterceptors(dispatchInterceptors);
                return this;
            }

            public Builder dispatchers(Map<Method, InvocationHandler> dispatchers) {
                this.dispatchers = new HashMap<Method, InvocationHandler>(dispatchers);
                return this;
            }

            public GatewayInvocationHandler build() {
                return new GatewayInvocationHandler(this);
            }
        }
    }

    public static interface InvocationHandler<R> {
        public R invoke(Object var1, Method var2, Object[] var3) throws Exception;
    }
}

