/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlerInvocationException;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.UnsupportedHandlerException;

public class AnnotatedMessageHandlingMember<T>
implements MessageHandlingMember<T> {
    private final Class<?> payloadType;
    private final int parameterCount;
    private final ParameterResolver<?>[] parameterResolvers;
    private final Executable executable;
    private final Class<? extends Message> messageType;

    public AnnotatedMessageHandlingMember(Executable executable, Class<? extends Message> messageType, Class<?> explicitPayloadType, ParameterResolverFactory parameterResolverFactory) {
        this.executable = executable;
        this.messageType = messageType;
        ReflectionUtils.ensureAccessible(this.executable);
        Parameter[] parameters = executable.getParameters();
        this.parameterCount = executable.getParameterCount();
        this.parameterResolvers = new ParameterResolver[this.parameterCount];
        Class<?> supportedPayloadType = explicitPayloadType;
        for (int i = 0; i < this.parameterCount; ++i) {
            this.parameterResolvers[i] = parameterResolverFactory.createInstance(executable, parameters, i);
            if (this.parameterResolvers[i] == null) {
                throw new UnsupportedHandlerException("Unable to resolve parameter " + i + " (" + parameters[i].getType().getSimpleName() + ") in handler " + executable.toGenericString() + ".", executable);
            }
            if (supportedPayloadType.isAssignableFrom(this.parameterResolvers[i].supportedPayloadType())) {
                supportedPayloadType = this.parameterResolvers[i].supportedPayloadType();
                continue;
            }
            if (this.parameterResolvers[i].supportedPayloadType().isAssignableFrom(supportedPayloadType)) continue;
            throw new UnsupportedHandlerException(String.format("The method %s seems to have parameters that put conflicting requirements on the payload type applicable on that method: %s vs %s", executable.toGenericString(), supportedPayloadType, this.parameterResolvers[i].supportedPayloadType()), executable);
        }
        this.payloadType = supportedPayloadType;
    }

    @Override
    public Class<?> payloadType() {
        return this.payloadType;
    }

    @Override
    public boolean canHandle(Message<?> message) {
        return this.typeMatches(message) && this.payloadType.isAssignableFrom(message.getPayloadType()) && this.parametersMatch(message);
    }

    @Override
    public boolean canHandleType(Class<?> payloadType) {
        return this.payloadType.isAssignableFrom(payloadType);
    }

    protected boolean typeMatches(Message<?> message) {
        return this.messageType.isInstance(message);
    }

    protected boolean parametersMatch(Message<?> message) {
        for (ParameterResolver<?> resolver : this.parameterResolvers) {
            if (resolver.matches(message)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object handle(Message<?> message, T target) throws Exception {
        try {
            if (this.executable instanceof Method) {
                return ((Method)this.executable).invoke(target, this.resolveParameterValues(message));
            }
            if (this.executable instanceof Constructor) {
                return ((Constructor)this.executable).newInstance(this.resolveParameterValues(message));
            }
            throw new IllegalStateException("What kind of handler is this?");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.checkAndRethrowForExceptionOrError(e);
            throw new MessageHandlerInvocationException(String.format("Error handling an object of type [%s]", message.getPayloadType()), e);
        }
    }

    private void checkAndRethrowForExceptionOrError(ReflectiveOperationException e) throws Exception {
        if (e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
    }

    private Object[] resolveParameterValues(Message<?> message) {
        Object[] params = new Object[this.parameterCount];
        for (int i = 0; i < this.parameterCount; ++i) {
            params[i] = this.parameterResolvers[i].resolveParameterValue(message);
        }
        return params;
    }

    @Override
    public Optional<Map<String, Object>> annotationAttributes(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotationAttributes((AnnotatedElement)this.executable, annotationType);
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotationPresent((AnnotatedElement)this.executable, annotationType);
    }

    @Override
    public <H> Optional<H> unwrap(Class<H> handlerType) {
        if (handlerType.isInstance(this.executable)) {
            return Optional.of(this.executable);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.executable.toGenericString();
    }

    public int hashCode() {
        return Objects.hash(this.executable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedMessageHandlingMember that = (AnnotatedMessageHandlingMember)o;
        return this.executable.equals(that.executable);
    }
}

