/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.commandfilter.CommandNameFilter;
import org.axonframework.commandhandling.distributed.commandfilter.DenyAll;
import org.axonframework.commandhandling.distributed.commandfilter.DenyCommandNameFilter;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.messaging.Distributed;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;

public class DistributedCommandBus
implements CommandBus,
Distributed<CommandBus> {
    public static final int INITIAL_LOAD_FACTOR = 100;
    private static final String DISPATCH_ERROR_MESSAGE = "An error occurred while trying to dispatch a command on the DistributedCommandBus";
    private final CommandRouter commandRouter;
    private final CommandBusConnector connector;
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final AtomicReference<CommandMessageFilter> commandFilter = new AtomicReference<DenyAll>(DenyAll.INSTANCE);
    private final CommandCallback<Object, Object> defaultCommandCallback;
    private volatile int loadFactor = 100;

    public static Builder builder() {
        return new Builder();
    }

    protected DistributedCommandBus(Builder builder) {
        builder.validate();
        this.commandRouter = builder.commandRouter;
        this.connector = builder.connector;
        this.messageMonitor = builder.messageMonitor;
        this.defaultCommandCallback = builder.defaultCommandCallback;
    }

    @ShutdownHandler(phase=0x1FFFFFFF)
    public void disconnect() {
        this.commandRouter.updateMembership(this.loadFactor, DenyAll.INSTANCE);
    }

    @ShutdownHandler(phase=0)
    public CompletableFuture<Void> shutdownDispatching() {
        return this.connector.initiateShutdown();
    }

    @Override
    public <C> void dispatch(CommandMessage<C> command) {
        if (this.defaultCommandCallback != null) {
            this.dispatch(command, this.defaultCommandCallback);
            return;
        }
        LoggingCallback loggingCallback = LoggingCallback.INSTANCE;
        if (NoOpMessageMonitor.INSTANCE.equals(this.messageMonitor)) {
            CommandMessage<C> interceptedCommand = this.intercept(command);
            Optional<Member> optionalDestination = this.commandRouter.findDestination(interceptedCommand);
            if (optionalDestination.isPresent()) {
                Member destination = optionalDestination.get();
                try {
                    this.connector.send(destination, interceptedCommand);
                }
                catch (Exception e) {
                    destination.suspect();
                    loggingCallback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(new CommandDispatchException("An error occurred while trying to dispatch a command on the DistributedCommandBus: " + e.getMessage(), e)));
                }
            } else {
                loggingCallback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(new NoHandlerForCommandException(String.format("No node known to accept [%s]", interceptedCommand.getCommandName()))));
            }
        } else {
            this.dispatch(command, loggingCallback);
        }
    }

    @Override
    public <C, R> void dispatch(CommandMessage<C> command, CommandCallback<? super C, ? super R> callback) {
        CommandMessage<C> interceptedCommand = this.intercept(command);
        MessageMonitor.MonitorCallback messageMonitorCallback = this.messageMonitor.onMessageIngested(interceptedCommand);
        Optional<Member> optionalDestination = this.commandRouter.findDestination(interceptedCommand);
        if (optionalDestination.isPresent()) {
            Member destination = optionalDestination.get();
            try {
                this.connector.send(destination, interceptedCommand, new MonitorAwareCallback<C, R>(callback, messageMonitorCallback));
            }
            catch (Exception e) {
                messageMonitorCallback.reportFailure(e);
                destination.suspect();
                callback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(new CommandDispatchException("An error occurred while trying to dispatch a command on the DistributedCommandBus: " + e.getMessage(), e)));
            }
        } else {
            NoHandlerForCommandException exception = new NoHandlerForCommandException(String.format("No node known to accept [%s]", interceptedCommand.getCommandName()));
            messageMonitorCallback.reportFailure(exception);
            callback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(exception));
        }
    }

    private <C> CommandMessage<? extends C> intercept(CommandMessage<C> command) {
        CommandMessage<C> interceptedCommand = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            interceptedCommand = interceptor.handle(interceptedCommand);
        }
        return interceptedCommand;
    }

    @Override
    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> handler) {
        Registration reg = this.connector.subscribe(commandName, handler);
        this.updateFilter(this.commandFilter.get().or(new CommandNameFilter(commandName)));
        return () -> {
            this.updateFilter(this.commandFilter.get().and(new DenyCommandNameFilter(commandName)));
            return reg.cancel();
        };
    }

    private void updateFilter(CommandMessageFilter newFilter) {
        if (!this.commandFilter.getAndSet(newFilter).equals(newFilter)) {
            this.commandRouter.updateMembership(this.loadFactor, newFilter);
        }
    }

    @Override
    public CommandBus localSegment() {
        return this.connector.localSegment().orElse(this);
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void updateLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
        this.commandRouter.updateMembership(loadFactor, this.commandFilter.get());
    }

    @Override
    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Override
    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.connector.registerHandlerInterceptor(handlerInterceptor);
    }

    public static class Builder {
        private CommandCallback<Object, Object> defaultCommandCallback = null;
        private CommandRouter commandRouter;
        private CommandBusConnector connector;
        private MessageMonitor<? super CommandMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;

        public Builder commandRouter(CommandRouter commandRouter) {
            BuilderUtils.assertNonNull(commandRouter, "CommandRouter may not be null");
            this.commandRouter = commandRouter;
            return this;
        }

        public Builder connector(CommandBusConnector connector) {
            BuilderUtils.assertNonNull(connector, "CommandBusConnector may not be null");
            this.connector = connector;
            return this;
        }

        public Builder messageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            this.defaultCommandCallback = defaultCommandCallback;
            return this;
        }

        public DistributedCommandBus build() {
            return new DistributedCommandBus(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.commandRouter, "The CommandRouter is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.connector, "The CommandBusConnector is a hard requirement and should be provided");
        }
    }
}

