/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.AbstractRetryScheduler;
import org.axonframework.common.BuilderUtils;

public class ExponentialBackOffIntervalRetryScheduler
extends AbstractRetryScheduler {
    private static final long DEFAULT_BACKOFF_FACTOR = 100L;
    private final long backoffFactor;

    protected ExponentialBackOffIntervalRetryScheduler(Builder builder) {
        super(builder);
        this.backoffFactor = builder.backoffFactor;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected long computeRetryInterval(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures) {
        int retryCount = failures.size();
        return this.backoffFactor * (1L << retryCount - 1);
    }

    public static class Builder
    extends AbstractRetryScheduler.Builder<Builder> {
        private long backoffFactor = 100L;

        public Builder backoffFactor(long backoffFactor) {
            this.backoffFactor = backoffFactor;
            return this;
        }

        public ExponentialBackOffIntervalRetryScheduler build() {
            return new ExponentialBackOffIntervalRetryScheduler(this);
        }

        @Override
        protected void validate() {
            BuilderUtils.assertStrictPositive(this.backoffFactor, "The backoff factor is a hard requirement and must be at least 1.");
        }
    }
}

