/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.time.Instant;
import org.axonframework.common.Priority;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.Timestamp;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolver;

@Priority(value=0x3FFFFFFF)
public final class TimestampParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<Timestamp, Instant> {
    private final ParameterResolver<Instant> resolver = new TimestampParameterResolver();

    public TimestampParameterResolverFactory() {
        super(Timestamp.class, Instant.class);
    }

    @Override
    protected ParameterResolver<Instant> getResolver() {
        return this.resolver;
    }

    static class TimestampParameterResolver
    implements ParameterResolver<Instant> {
        TimestampParameterResolver() {
        }

        @Override
        public Instant resolveParameterValue(Message message) {
            if (message instanceof EventMessage) {
                return ((EventMessage)message).getTimestamp();
            }
            return null;
        }

        @Override
        public boolean matches(Message message) {
            return message instanceof EventMessage;
        }
    }
}

