/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.ConnectionWrapperFactory;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class UnitOfWorkAwareConnectionProviderWrapper
implements ConnectionProvider {
    private static final String CONNECTION_RESOURCE_NAME = Connection.class.getName();
    private final ConnectionProvider delegate;

    public UnitOfWorkAwareConnectionProviderWrapper(ConnectionProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!CurrentUnitOfWork.isStarted() || CurrentUnitOfWork.get().phase().isAfter(UnitOfWork.Phase.PREPARE_COMMIT)) {
            return this.delegate.getConnection();
        }
        UnitOfWork<?> uow = CurrentUnitOfWork.get();
        Connection connection = (Connection)uow.root().getResource(CONNECTION_RESOURCE_NAME);
        if (connection == null || connection.isClosed()) {
            Connection delegateConnection = this.delegate.getConnection();
            connection = ConnectionWrapperFactory.wrap(delegateConnection, UoWAttachedConnection.class, new UoWAttachedConnectionImpl(delegateConnection), new ConnectionWrapperFactory.NoOpCloseHandler());
            uow.root().resources().put(CONNECTION_RESOURCE_NAME, connection);
            uow.onCommit(u -> {
                Connection cx = (Connection)u.root().getResource(CONNECTION_RESOURCE_NAME);
                try {
                    if (cx instanceof UoWAttachedConnection) {
                        ((UoWAttachedConnection)((Object)cx)).forceCommit();
                    } else if (!cx.isClosed() && !cx.getAutoCommit()) {
                        cx.commit();
                    }
                }
                catch (SQLException e) {
                    throw new JdbcException("Unable to commit transaction", e);
                }
            });
            uow.onCleanup(u -> {
                Connection cx = (Connection)u.root().getResource(CONNECTION_RESOURCE_NAME);
                JdbcUtils.closeQuietly(cx);
                if (cx instanceof UoWAttachedConnection) {
                    ((UoWAttachedConnection)((Object)cx)).forceClose();
                }
            });
            uow.onRollback(u -> {
                Connection cx = (Connection)u.root().getResource(CONNECTION_RESOURCE_NAME);
                try {
                    if (!cx.isClosed() && !cx.getAutoCommit()) {
                        cx.rollback();
                    }
                }
                catch (SQLException ex) {
                    if (u.getExecutionResult().isExceptionResult()) {
                        ExecutionException executeException = new ExecutionException("Unable to rollback transaction", u.getExecutionResult().getExceptionResult());
                        executeException.addSuppressed(ex);
                        throw executeException;
                    }
                    throw new JdbcException("Unable to rollback transaction", ex);
                }
            });
        }
        return connection;
    }

    private static class UoWAttachedConnectionImpl
    implements UoWAttachedConnection {
        private final Connection delegateConnection;

        private UoWAttachedConnectionImpl(Connection delegateConnection) {
            this.delegateConnection = delegateConnection;
        }

        @Override
        public void forceClose() {
            JdbcUtils.closeQuietly(this.delegateConnection);
        }

        @Override
        public void forceCommit() throws SQLException {
            if (!this.delegateConnection.isClosed() && !this.delegateConnection.getAutoCommit()) {
                this.delegateConnection.commit();
            }
        }
    }

    private static interface UoWAttachedConnection {
        public void forceClose();

        public void forceCommit() throws SQLException;
    }
}

