/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Map;
import java.util.WeakHashMap;
import org.axonframework.common.ReflectionUtils;

public final class IdentifierValidator {
    private static final IdentifierValidator INSTANCE = new IdentifierValidator();
    private static final Object NULL = new Object();
    private final Map<Class<?>, Object> whiteList = new WeakHashMap();

    private IdentifierValidator() {
    }

    public static IdentifierValidator getInstance() {
        return INSTANCE;
    }

    public boolean isValidIdentifier(Class<?> identifierType) {
        if (!this.whiteList.containsKey(identifierType)) {
            if (Object.class.equals(ReflectionUtils.declaringClass(identifierType, "toString", new Class[0]))) {
                return false;
            }
            this.whiteList.put(identifierType, NULL);
        }
        return true;
    }
}

