/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing.attributes;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.tracing.SpanAttributesProvider;

public class MessageNameSpanAttributesProvider
implements SpanAttributesProvider {
    @Override
    @Nonnull
    public Map<String, String> provideForMessage(@Nonnull Message<?> message) {
        String name = this.determineName(message);
        if (name != null) {
            return Collections.singletonMap("axon_message_name", name);
        }
        return Collections.emptyMap();
    }

    private String determineName(Message<?> message) {
        if (message instanceof CommandMessage) {
            return ((CommandMessage)message).getCommandName();
        }
        if (message instanceof QueryMessage) {
            return QueryMessage.queryName(message);
        }
        return null;
    }
}

