/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.message.SchemaStore;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.avro.AvroUtil;

public class ByteArrayToGenericRecordConverter
implements ContentTypeConverter<byte[], GenericRecord> {
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private final SchemaStore schemaStore;

    public ByteArrayToGenericRecordConverter(SchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    @Override
    public Class<byte[]> expectedSourceType() {
        return byte[].class;
    }

    @Override
    public Class<GenericRecord> targetType() {
        return GenericRecord.class;
    }

    @Override
    public GenericRecord convert(byte[] singleObjectEncodeBytes) {
        long fingerprint = AvroUtil.fingerprint(singleObjectEncodeBytes);
        Schema writerSchema = this.schemaStore.findByFingerprint(fingerprint);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, writerSchema, AvroUtil.genericData);
        try {
            return (GenericRecord)reader.read(null, (Decoder)decoderFactory.binaryDecoder(AvroUtil.payload(singleObjectEncodeBytes), null));
        }
        catch (IOException e) {
            throw new CannotConvertBetweenTypesException("Cannot convert bytes to GenericRecord", e);
        }
    }
}

