/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.axonframework.common.BuilderUtils;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerHttpClient.class);
    private final UsagePropertyProvider userProperties;

    public UpdateCheckerHttpClient(UsagePropertyProvider userProperties) {
        BuilderUtils.assertNonNull(userProperties, "The userProperties must not be null.");
        this.userProperties = userProperties;
    }

    public Optional<UpdateCheckResponse> sendRequest(UpdateCheckRequest updateCheckRequest, boolean firstRequest) {
        String url = this.userProperties.getUrl() + "?" + updateCheckRequest.toQueryString();
        try {
            logger.debug("Reporting anonymous usage data to AxonIQ servers at: {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("User-Agent", updateCheckRequest.toUserAgent());
            connection.setRequestProperty("X-Machine-Id", updateCheckRequest.machineId());
            connection.setRequestProperty("X-Instance-Id", updateCheckRequest.instanceId());
            connection.setRequestProperty("X-Uptime", String.valueOf(ManagementFactory.getRuntimeMXBean().getUptime()));
            connection.setRequestProperty("X-First-Run", firstRequest ? "true" : "false");
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                logger.info("Failed to report anonymous usage data, received status code: {}", (Object)statusCode);
                return Optional.empty();
            }
            String responseBody = this.readResponse(connection);
            logger.debug("Reported anonymous usage data successfully, received response: {}", (Object)responseBody);
            return Optional.of(UpdateCheckResponse.fromRequest(responseBody));
        }
        catch (Exception e) {
            logger.warn("Failed to report anonymous usage data", (Throwable)e);
            return Optional.empty();
        }
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

