/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import java.util.List;
import java.util.function.Function;
import org.axonframework.updates.UpdateCheckerReporter;
import org.axonframework.updates.api.Artifact;
import org.axonframework.updates.api.DetectedVulnerability;
import org.axonframework.updates.api.UpdateCheckRequest;
import org.axonframework.updates.api.UpdateCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUpdateCheckerReporter
implements UpdateCheckerReporter {
    private static Logger logger = LoggerFactory.getLogger(LoggingUpdateCheckerReporter.class);

    @Override
    public void report(UpdateCheckRequest request, UpdateCheckResponse updateCheckResponse) {
        boolean hasVulnerabilities;
        boolean hasUpgrades = !updateCheckResponse.upgrades().isEmpty();
        boolean bl = hasVulnerabilities = !updateCheckResponse.vulnerabilities().isEmpty();
        if (hasVulnerabilities) {
            logger.error("AxonIQ has found the following vulnerabilities in your Axon libraries:");
            this.logVulnerabilities(updateCheckResponse);
            if (hasUpgrades) {
                logger.info("Additionally, AxonIQ has found an upgrade(s) for your Axon libraries:");
                this.logUpgrades(request, updateCheckResponse);
            }
        } else if (hasUpgrades) {
            logger.info("AxonIQ has found the following dependency upgrade(s):");
            this.logUpgrades(request, updateCheckResponse);
            logger.info("No vulnerabilities have been found in your Axon libraries.");
        } else {
            logger.info("All your AxonIQ libraries are up-to-date, no upgrades or vulnerabilities found.");
        }
    }

    private void logUpgrades(UpdateCheckRequest requestBody, UpdateCheckResponse updateCheckResponse) {
        int nameLength = this.calculateStringLength(requestBody.libraries(), upgrade -> upgrade.groupId() + ":" + upgrade.artifactId()) + 2;
        int versionLength = this.calculateStringLength(requestBody.libraries(), Artifact::version);
        updateCheckResponse.upgrades().forEach(upgrade -> {
            String currentVersion = LoggingUpdateCheckerReporter.getCurrentVersionForArtifact(requestBody, upgrade.groupId(), upgrade.artifactId());
            logger.info("{} {} -> {}", new Object[]{this.rightPad(upgrade.groupId() + ":" + upgrade.artifactId(), nameLength, '.'), this.rightPad(currentVersion, versionLength, ' '), upgrade.latestVersion()});
        });
    }

    private static String getCurrentVersionForArtifact(UpdateCheckRequest requestBody, String groupId, String artifactId) {
        return requestBody.libraries().stream().filter(v -> v.artifactId().equals(artifactId) && v.groupId().equals(groupId)).findFirst().map(Artifact::version).orElse("unknown");
    }

    private <T> int calculateStringLength(List<T> items, Function<T, String> stringExtractor) {
        return items.stream().map(stringExtractor).mapToInt(String::length).max().orElse(0);
    }

    private String rightPad(String str, int length, char padChar) {
        if (str.length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < length - str.length(); ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    private void logVulnerabilities(UpdateCheckResponse updateCheckResponse) {
        int nameLength = this.calculateStringLength(updateCheckResponse.vulnerabilities(), upgrade -> upgrade.groupId() + ":" + upgrade.artifactId()) + 2;
        int severityLength = this.calculateStringLength(updateCheckResponse.vulnerabilities(), vulnerability -> vulnerability.severity().toString());
        int fixVersionLength = this.calculateStringLength(updateCheckResponse.vulnerabilities(), DetectedVulnerability::fixVersion);
        updateCheckResponse.vulnerabilities().forEach(vulnerability -> logger.error("[{}] {} [Fixed in: {}] Description: {}", new Object[]{this.rightPad(vulnerability.severity().toString(), severityLength, ' '), this.rightPad(vulnerability.groupId() + ":" + vulnerability.artifactId(), nameLength, '.'), this.rightPad(vulnerability.fixVersion(), fixVersionLength, ' '), vulnerability.description()}));
    }
}

