/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;

public class MetaDataSequencingPolicy
implements SequencingPolicy<EventMessage<?>> {
    private final String metaDataKey;

    protected MetaDataSequencingPolicy(Builder builder) {
        builder.validate();
        this.metaDataKey = builder.metaDataKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object getSequenceIdentifierFor(@Nonnull EventMessage<?> event) {
        return event.getMetaData().getOrDefault(this.metaDataKey, event.getIdentifier());
    }

    public static class Builder {
        private String metaDataKey;

        private Builder() {
        }

        public Builder metaDataKey(String metaDataKey) {
            this.metaDataKey = metaDataKey;
            return this;
        }

        public MetaDataSequencingPolicy build() {
            return new MetaDataSequencingPolicy(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.metaDataKey, "MetaDataKey value may not be null");
        }
    }
}

