/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.DefaultSubscriptionQueryResult;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericQueryResponseMessage;
import org.axonframework.queryhandling.GenericStreamingQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryBackpressure;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DefaultQueryGateway
implements QueryGateway {
    private final QueryBus queryBus;
    private final List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors;

    protected DefaultQueryGateway(Builder builder) {
        builder.validate();
        this.queryBus = builder.queryBus;
        this.dispatchInterceptors = builder.dispatchInterceptors;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <R, Q> CompletableFuture<R> query(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<R> responseType) {
        CompletableFuture queryResponse = this.queryBus.query(this.processInterceptors(new GenericQueryMessage(GenericMessage.asMessage(query), queryName, responseType)));
        CompletableFuture result = new CompletableFuture();
        result.whenComplete((r, e) -> {
            if (!queryResponse.isDone()) {
                queryResponse.cancel(true);
            }
        });
        ((CompletableFuture)queryResponse.exceptionally(cause -> GenericQueryResponseMessage.asResponseMessage(responseType.responseMessagePayloadType(), cause))).thenAccept(queryResponseMessage -> {
            try {
                if (queryResponseMessage.isExceptional()) {
                    result.completeExceptionally(queryResponseMessage.exceptionResult());
                } else {
                    result.complete(queryResponseMessage.getPayload());
                }
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    @Override
    public <R, Q> Publisher<R> streamingQuery(String queryName, Q query, Class<R> responseType) {
        return Mono.fromSupplier(() -> new GenericStreamingQueryMessage(GenericMessage.asMessage(query), queryName, responseType)).flatMapMany(queryMessage -> this.queryBus.streamingQuery(this.processInterceptors(queryMessage))).map(Message::getPayload);
    }

    @Override
    public <R, Q> Stream<R> scatterGather(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<R> responseType, long timeout, @Nonnull TimeUnit timeUnit) {
        GenericQueryMessage queryMessage = new GenericQueryMessage(GenericMessage.asMessage(query), queryName, responseType);
        return this.queryBus.scatterGather(this.processInterceptors(queryMessage), timeout, timeUnit).map(Message::getPayload);
    }

    @Override
    @Deprecated
    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<I> initialResponseType, @Nonnull ResponseType<U> updateResponseType, @Nullable SubscriptionQueryBackpressure backpressure, int updateBufferSize) {
        SubscriptionQueryMessage<?, I, U> interceptedQuery = this.getSubscriptionQueryMessage(queryName, query, initialResponseType, updateResponseType);
        SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> result = this.queryBus.subscriptionQuery(interceptedQuery, backpressure, updateBufferSize);
        return this.getSubscriptionQueryResult(result);
    }

    @Override
    public <Q, I, U> SubscriptionQueryResult<I, U> subscriptionQuery(@Nonnull String queryName, @Nonnull Q query, @Nonnull ResponseType<I> initialResponseType, @Nonnull ResponseType<U> updateResponseType, int updateBufferSize) {
        SubscriptionQueryMessage<?, I, U> interceptedQuery = this.getSubscriptionQueryMessage(queryName, query, initialResponseType, updateResponseType);
        SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> result = this.queryBus.subscriptionQuery(interceptedQuery, updateBufferSize);
        return this.getSubscriptionQueryResult(result);
    }

    private <Q, I, U> SubscriptionQueryMessage<?, I, U> getSubscriptionQueryMessage(String queryName, Q query, ResponseType<I> initialResponseType, ResponseType<U> updateResponseType) {
        GenericSubscriptionQueryMessage subscriptionQueryMessage = new GenericSubscriptionQueryMessage(GenericMessage.asMessage(query), queryName, initialResponseType, updateResponseType);
        return this.processInterceptors(subscriptionQueryMessage);
    }

    private <I, U> DefaultSubscriptionQueryResult<I, U> getSubscriptionQueryResult(SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> result) {
        return new DefaultSubscriptionQueryResult(result.initialResult().filter(initialResult -> Objects.nonNull(initialResult.getPayload())).map(Message::getPayload).onErrorMap(e -> e instanceof IllegalPayloadAccessException ? e.getCause() : e), result.updates().filter(update -> Objects.nonNull(update.getPayload())).map(Message::getPayload), result);
    }

    @Override
    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super QueryMessage<?, ?>> interceptor) {
        this.dispatchInterceptors.add(interceptor);
        return () -> this.dispatchInterceptors.remove(interceptor);
    }

    private <Q, R, T extends QueryMessage<Q, R>> T processInterceptors(T query) {
        Object intercepted = query;
        for (MessageDispatchInterceptor<QueryMessage<?, ?>> interceptor : this.dispatchInterceptors) {
            intercepted = interceptor.handle((QueryMessage<?, ?>)intercepted);
        }
        return intercepted;
    }

    public static class Builder {
        private QueryBus queryBus;
        private List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors = new CopyOnWriteArrayList();

        public Builder queryBus(@Nonnull QueryBus queryBus) {
            BuilderUtils.assertNonNull(queryBus, "QueryBus may not be null");
            this.queryBus = queryBus;
            return this;
        }

        public Builder dispatchInterceptors(MessageDispatchInterceptor<? super QueryMessage<?, ?>> ... dispatchInterceptors) {
            return this.dispatchInterceptors(Arrays.asList(dispatchInterceptors));
        }

        public Builder dispatchInterceptors(List<MessageDispatchInterceptor<? super QueryMessage<?, ?>>> dispatchInterceptors) {
            this.dispatchInterceptors = dispatchInterceptors != null && !dispatchInterceptors.isEmpty() ? new CopyOnWriteArrayList(dispatchInterceptors) : new CopyOnWriteArrayList();
            return this;
        }

        public DefaultQueryGateway build() {
            return new DefaultQueryGateway(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.queryBus, "The QueryBus is a hard requirement and should be provided");
        }
    }
}

