/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.annotation.QueryHandlingMember;

public class MethodQueryMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    public <T> MessageHandlingMember<T> wrapHandler(MessageHandlingMember<T> original) {
        return original.annotationAttributes(QueryHandler.class).map(attr -> new MethodQueryMessageHandlingMember(original, (Map<String, Object>)attr)).orElse(original);
    }

    private class MethodQueryMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements QueryHandlingMember<T> {
        private final String queryName;
        private final Type resultType;

        public MethodQueryMessageHandlingMember(MessageHandlingMember<T> original, Map<String, Object> attr) {
            super(original);
            String queryNameAttribute = (String)attr.get("queryName");
            if ("".equals(queryNameAttribute)) {
                queryNameAttribute = original.payloadType().getName();
            }
            this.queryName = queryNameAttribute;
            this.resultType = original.unwrap(Method.class).map(this::queryResultType).orElseThrow(() -> new UnsupportedHandlerException("@QueryHandler annotation can only be put on methods.", original.unwrap(Member.class).orElse(null)));
            if (Void.TYPE.equals(this.resultType)) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", original.unwrap(Member.class).orElse(null));
            }
        }

        private Type queryResultType(Method method) {
            if (Void.class.equals(method.getReturnType())) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", method);
            }
            return ReflectionUtils.resolvePrimitiveWrapperTypeIfPrimitive(method.getGenericReturnType());
        }

        @Override
        public boolean canHandle(Message<?> message) {
            return super.canHandle(message) && message instanceof QueryMessage && this.queryName.equals(((QueryMessage)message).getQueryName()) && ((QueryMessage)message).getResponseType().matches(this.resultType);
        }

        @Override
        public String getQueryName() {
            return this.queryName;
        }

        @Override
        public Type getResultType() {
            return this.resultType;
        }
    }
}

