/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.interceptors.JSR303ViolationException;
import org.axonframework.messaging.unitofwork.UnitOfWork;

public class BeanValidationInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T>,
MessageDispatchInterceptor<T> {
    private final ValidatorFactory validatorFactory;

    public BeanValidationInterceptor() {
        this(Validation.buildDefaultValidatorFactory());
    }

    public BeanValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public Object handle(UnitOfWork<? extends T> unitOfWork, InterceptorChain interceptorChain) throws Exception {
        this.handle(unitOfWork.getMessage());
        return interceptorChain.proceed();
    }

    @Override
    public BiFunction<Integer, T, T> handle(List<? extends T> messages) {
        return (index, message) -> {
            Validator validator = this.validatorFactory.getValidator();
            Set<ConstraintViolation<Object>> violations = this.validateMessage(message.getPayload(), validator);
            if (violations != null && !violations.isEmpty()) {
                throw new JSR303ViolationException(violations);
            }
            return message;
        };
    }

    protected Set<ConstraintViolation<Object>> validateMessage(Object message, Validator validator) {
        return validator.validate(message, new Class[0]);
    }
}

