/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.axonframework.serialization.upcasting.Upcaster;

public class GenericUpcasterChain<T>
implements Upcaster<T> {
    private final List<? extends Upcaster<T>> upcasters;

    @SafeVarargs
    public GenericUpcasterChain(Upcaster<T> ... upcasters) {
        this(Arrays.asList(upcasters));
    }

    public GenericUpcasterChain(List<? extends Upcaster<T>> upcasters) {
        this.upcasters = new ArrayList<Upcaster<T>>(upcasters);
    }

    @Override
    public Stream<T> upcast(Stream<T> initialRepresentations) {
        Stream<T> result = initialRepresentations;
        for (Upcaster<T> upcaster : this.getUpcasters()) {
            result = upcaster.upcast(result);
        }
        return result;
    }

    protected List<? extends Upcaster<T>> getUpcasters() {
        return this.upcasters;
    }
}

