/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.util.Comparator;
import java.util.Objects;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public final class HandlerComparator {
    private static final Comparator<MessageHandlingMember<?>> INSTANCE = Comparator.comparing(MessageHandlingMember::payloadType, HandlerComparator::compareHierarchy).thenComparing(Comparator.comparingInt(MessageHandlingMember::priority).reversed()).thenComparing(m -> m.unwrap(Executable.class).map(Executable::toGenericString).orElse(m.toString()));

    private HandlerComparator() {
    }

    public static Comparator<MessageHandlingMember<?>> instance() {
        return INSTANCE;
    }

    private static int compareHierarchy(Class<?> o1, Class<?> o2) {
        if (Objects.equals(o1, o2)) {
            return 0;
        }
        if (o1.isAssignableFrom(o2)) {
            return 1;
        }
        if (o2.isAssignableFrom(o1)) {
            return -1;
        }
        return Integer.compare(HandlerComparator.depthOf(o2), HandlerComparator.depthOf(o1));
    }

    private static int depthOf(Class<?> o1) {
        int depth = 0;
        for (Class<?> type = o1; type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            ++depth;
        }
        if (o1.isAnnotation()) {
            depth += 1000;
        }
        return depth;
    }
}

