/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Map;
import java.util.Optional;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;

public class GenericResultMessage<R>
extends MessageDecorator<R>
implements ResultMessage<R> {
    private static final long serialVersionUID = -9086395619674962782L;
    private final Throwable exception;

    public static <T> ResultMessage<T> asResultMessage(Object result) {
        if (ResultMessage.class.isInstance(result)) {
            return (ResultMessage)result;
        }
        if (Message.class.isInstance(result)) {
            Message resultMessage = (Message)result;
            return new GenericResultMessage(resultMessage.getPayload(), resultMessage.getMetaData());
        }
        return new GenericResultMessage<Object>(result);
    }

    public static <T> ResultMessage<T> asResultMessage(Throwable exception) {
        return new GenericResultMessage(exception);
    }

    public GenericResultMessage(R result) {
        this(result, MetaData.emptyInstance());
    }

    public GenericResultMessage(Throwable exception) {
        this(exception, (Map<String, ?>)MetaData.emptyInstance());
    }

    public GenericResultMessage(R result, Map<String, ?> metaData) {
        this((Message<R>)new GenericMessage<R>(result, metaData));
    }

    public GenericResultMessage(Throwable exception, Map<String, ?> metaData) {
        this(new GenericMessage<Object>(null, metaData), exception);
    }

    public GenericResultMessage(Message<R> delegate) {
        this(delegate, (Throwable)null);
    }

    public GenericResultMessage(Message<R> delegate, Throwable exception) {
        super(delegate);
        this.exception = exception;
    }

    @Override
    public boolean isExceptional() {
        return this.exception != null;
    }

    @Override
    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    @Override
    public GenericResultMessage<R> withMetaData(Map<String, ?> metaData) {
        return new GenericResultMessage(this.getDelegate().withMetaData(metaData), this.exception);
    }

    @Override
    public GenericResultMessage<R> andMetaData(Map<String, ?> metaData) {
        return new GenericResultMessage(this.getDelegate().andMetaData(metaData), this.exception);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        stringBuilder.append("payload={").append((Object)(this.isExceptional() ? null : this.getPayload())).append('}').append(", metadata={").append(this.getMetaData()).append('}').append(", messageIdentifier='").append(this.getIdentifier()).append('\'').append(", exception='").append(this.exception).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericResultMessage";
    }

    @Override
    public R getPayload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return (R)super.getPayload();
    }
}

